package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link JobSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJobSpecAssert<S extends AbstractJobSpecAssert<S, A>, A extends JobSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobSpecAssert}</code> to make assertions on actual JobSpec.
   * @param actual the JobSpec we want to make assertions on.
   */
  protected AbstractJobSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Verifies that the actual JobSpec's activeDeadlineSeconds is equal to the given one.
   * @param activeDeadlineSeconds the given activeDeadlineSeconds to compare the actual JobSpec's activeDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpec's activeDeadlineSeconds is not equal to the given one.
   */
  public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    // check that actual JobSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualActiveDeadlineSeconds = actual.getActiveDeadlineSeconds();
    if (!Objects.areEqual(actualActiveDeadlineSeconds, activeDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, activeDeadlineSeconds, actualActiveDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual JobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual JobSpec's completions is equal to the given one.
   * @param completions the given completions to compare the actual JobSpec's completions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpec's completions is not equal to the given one.
   */
  public S hasCompletions(Integer completions) {
    // check that actual JobSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting completions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCompletions = actual.getCompletions();
    if (!Objects.areEqual(actualCompletions, completions)) {
      failWithMessage(assertjErrorMessage, actual, completions, actualCompletions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property manualSelector so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert manualSelector()  {
    // check that actual JobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getManualSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "manualSelector"));
  }


  /**
   * Verifies that the actual JobSpec's parallelism is equal to the given one.
   * @param parallelism the given parallelism to compare the actual JobSpec's parallelism to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpec's parallelism is not equal to the given one.
   */
  public S hasParallelism(Integer parallelism) {
    // check that actual JobSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting parallelism of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualParallelism = actual.getParallelism();
    if (!Objects.areEqual(actualParallelism, parallelism)) {
      failWithMessage(assertjErrorMessage, actual, parallelism, actualParallelism);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public LabelSelectorAssert selector()  {
    // check that actual JobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LabelSelectorAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public PodTemplateSpecAssert template()  {
    // check that actual JobSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodTemplateSpecAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


}
