package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link KeyToPath} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKeyToPathAssert<S extends AbstractKeyToPathAssert<S, A>, A extends KeyToPath> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKeyToPathAssert}</code> to make assertions on actual KeyToPath.
   * @param actual the KeyToPath we want to make assertions on.
   */
  protected AbstractKeyToPathAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual KeyToPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property key so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert key()  {
    // check that actual KeyToPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "key"));
  }


  /**
   * Verifies that the actual KeyToPath's mode is equal to the given one.
   * @param mode the given mode to compare the actual KeyToPath's mode to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KeyToPath's mode is not equal to the given one.
   */
  public S hasMode(Integer mode) {
    // check that actual KeyToPath we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting mode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMode = actual.getMode();
    if (!Objects.areEqual(actualMode, mode)) {
      failWithMessage(assertjErrorMessage, actual, mode, actualMode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual KeyToPath we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


}
