package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link LabelSelectorRequirement} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLabelSelectorRequirementAssert<S extends AbstractLabelSelectorRequirementAssert<S, A>, A extends LabelSelectorRequirement> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLabelSelectorRequirementAssert}</code> to make assertions on actual LabelSelectorRequirement.
   * @param actual the LabelSelectorRequirement we want to make assertions on.
   */
  protected AbstractLabelSelectorRequirementAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual LabelSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property key so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert key()  {
    // check that actual LabelSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "key"));
  }


  /**
   * Navigates to the property operator so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert operator()  {
    // check that actual LabelSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOperator()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "operator"));
  }


  /**
   * Navigates to the property values so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> values()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getValues(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "values"));
    return answer;
  }


}
