package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Lifecycle} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLifecycleAssert<S extends AbstractLifecycleAssert<S, A>, A extends Lifecycle> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLifecycleAssert}</code> to make assertions on actual Lifecycle.
   * @param actual the Lifecycle we want to make assertions on.
   */
  protected AbstractLifecycleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Lifecycle we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property postStart so that assertions can be done on it
   */
  public HandlerAssert postStart()  {
    // check that actual Lifecycle we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HandlerAssert) assertThat(actual.getPostStart()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "postStart"));
  }


  /**
   * Navigates to the property preStop so that assertions can be done on it
   */
  public HandlerAssert preStop()  {
    // check that actual Lifecycle we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HandlerAssert) assertThat(actual.getPreStop()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preStop"));
  }


}
