package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link LimitRangeItem} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLimitRangeItemAssert<S extends AbstractLimitRangeItemAssert<S, A>, A extends LimitRangeItem> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLimitRangeItemAssert}</code> to make assertions on actual LimitRangeItem.
   * @param actual the LimitRangeItem we want to make assertions on.
   */
  protected AbstractLimitRangeItemAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual LimitRangeItem we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property default so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert expectedDefault()  {
    // check that actual LimitRangeItem we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getDefault()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "default"));
  }


  /**
   * Navigates to the property defaultRequest so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert defaultRequest()  {
    // check that actual LimitRangeItem we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getDefaultRequest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "defaultRequest"));
  }


  /**
   * Navigates to the property max so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert max()  {
    // check that actual LimitRangeItem we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getMax()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "max"));
  }


  /**
   * Navigates to the property maxLimitRequestRatio so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert maxLimitRequestRatio()  {
    // check that actual LimitRangeItem we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getMaxLimitRequestRatio()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "maxLimitRequestRatio"));
  }


  /**
   * Navigates to the property min so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert min()  {
    // check that actual LimitRangeItem we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getMin()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "min"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual LimitRangeItem we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
