package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link LoadBalancerStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLoadBalancerStatusAssert<S extends AbstractLoadBalancerStatusAssert<S, A>, A extends LoadBalancerStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLoadBalancerStatusAssert}</code> to make assertions on actual LoadBalancerStatus.
   * @param actual the LoadBalancerStatus we want to make assertions on.
   */
  protected AbstractLoadBalancerStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual LoadBalancerStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property ingress so that assertions can be done on it
   */
  public NavigationListAssert<LoadBalancerIngress, LoadBalancerIngressAssert> ingress()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<LoadBalancerIngress, LoadBalancerIngressAssert> assertFactory = new AssertFactory<LoadBalancerIngress, LoadBalancerIngressAssert>() {
      public LoadBalancerIngressAssert createAssert(LoadBalancerIngress t) {
        return (LoadBalancerIngressAssert) assertThat(t);
      }
    };
    NavigationListAssert<LoadBalancerIngress, LoadBalancerIngressAssert> answer = new NavigationListAssert<LoadBalancerIngress, LoadBalancerIngressAssert>(actual.getIngress(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ingress"));
    return answer;
  }


}
