package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ObjectFieldSelector} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractObjectFieldSelectorAssert<S extends AbstractObjectFieldSelectorAssert<S, A>, A extends ObjectFieldSelector> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractObjectFieldSelectorAssert}</code> to make assertions on actual ObjectFieldSelector.
   * @param actual the ObjectFieldSelector we want to make assertions on.
   */
  protected AbstractObjectFieldSelectorAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ObjectFieldSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ObjectFieldSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property fieldPath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fieldPath()  {
    // check that actual ObjectFieldSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFieldPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fieldPath"));
  }


}
