package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PodSecurityContext} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSecurityContextAssert<S extends AbstractPodSecurityContextAssert<S, A>, A extends PodSecurityContext> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSecurityContextAssert}</code> to make assertions on actual PodSecurityContext.
   * @param actual the PodSecurityContext we want to make assertions on.
   */
  protected AbstractPodSecurityContextAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual PodSecurityContext's fsGroup is equal to the given one.
   * @param fsGroup the given fsGroup to compare the actual PodSecurityContext's fsGroup to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContext's fsGroup is not equal to the given one.
   */
  public S hasFsGroup(Long fsGroup) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualFsGroup = actual.getFsGroup();
    if (!Objects.areEqual(actualFsGroup, fsGroup)) {
      failWithMessage(assertjErrorMessage, actual, fsGroup, actualFsGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property runAsNonRoot so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert runAsNonRoot()  {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getRunAsNonRoot()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runAsNonRoot"));
  }


  /**
   * Verifies that the actual PodSecurityContext's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual PodSecurityContext's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSecurityContext's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(Long runAsUser) {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property seLinuxOptions so that assertions can be done on it
   */
  public SELinuxOptionsAssert seLinuxOptions()  {
    // check that actual PodSecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SELinuxOptionsAssert) assertThat(actual.getSeLinuxOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "seLinuxOptions"));
  }


  /**
   * Navigates to the property supplementalGroups so that assertions can be done on it
   */
  public NavigationListAssert<Long, org.assertj.core.api.LongAssert> supplementalGroups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Long, org.assertj.core.api.LongAssert> assertFactory = new AssertFactory<Long, org.assertj.core.api.LongAssert>() {
      public org.assertj.core.api.LongAssert createAssert(Long t) {
        return (org.assertj.core.api.LongAssert) assertThat(t);
      }
    };
    NavigationListAssert<Long, org.assertj.core.api.LongAssert> answer = new NavigationListAssert<Long, org.assertj.core.api.LongAssert>(actual.getSupplementalGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "supplementalGroups"));
    return answer;
  }


}
