package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Quantity} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractQuantityAssert<S extends AbstractQuantityAssert<S, A>, A extends Quantity> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractQuantityAssert}</code> to make assertions on actual Quantity.
   * @param actual the Quantity we want to make assertions on.
   */
  protected AbstractQuantityAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Quantity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property amount so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert amount()  {
    // check that actual Quantity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAmount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "amount"));
  }


  /**
   * Navigates to the property format so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert format()  {
    // check that actual Quantity we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFormat()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "format"));
  }


}
