package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link SecretList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecretListAssert<S extends AbstractSecretListAssert<S, A>, A extends SecretList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecretListAssert}</code> to make assertions on actual SecretList.
   * @param actual the SecretList we want to make assertions on.
   */
  protected AbstractSecretListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SecretList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual SecretList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<Secret, SecretAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Secret, SecretAssert> assertFactory = new AssertFactory<Secret, SecretAssert>() {
      public SecretAssert createAssert(Secret t) {
        return (SecretAssert) assertThat(t);
      }
    };
    NavigationListAssert<Secret, SecretAssert> answer = new NavigationListAssert<Secret, SecretAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual SecretList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ListMetaAssert metadata()  {
    // check that actual SecretList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ListMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


}
