package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link SecurityContextConstraints} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecurityContextConstraintsAssert<S extends AbstractSecurityContextConstraintsAssert<S, A>, A extends SecurityContextConstraints> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecurityContextConstraintsAssert}</code> to make assertions on actual SecurityContextConstraints.
   * @param actual the SecurityContextConstraints we want to make assertions on.
   */
  protected AbstractSecurityContextConstraintsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowHostDirVolumePlugin so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowHostDirVolumePlugin()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowHostDirVolumePlugin()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostDirVolumePlugin"));
  }


  /**
   * Navigates to the property allowHostIPC so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowHostIPC()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowHostIPC()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostIPC"));
  }


  /**
   * Navigates to the property allowHostNetwork so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowHostNetwork()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowHostNetwork()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostNetwork"));
  }


  /**
   * Navigates to the property allowHostPID so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowHostPID()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowHostPID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostPID"));
  }


  /**
   * Navigates to the property allowHostPorts so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowHostPorts()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowHostPorts()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostPorts"));
  }


  /**
   * Navigates to the property allowPrivilegedContainer so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowPrivilegedContainer()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowPrivilegedContainer()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowPrivilegedContainer"));
  }


  /**
   * Navigates to the property allowedCapabilities so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> allowedCapabilities()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAllowedCapabilities(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedCapabilities"));
    return answer;
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property defaultAddCapabilities so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> defaultAddCapabilities()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getDefaultAddCapabilities(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "defaultAddCapabilities"));
    return answer;
  }


  /**
   * Navigates to the property fsGroup so that assertions can be done on it
   */
  public FSGroupStrategyOptionsAssert fsGroup()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FSGroupStrategyOptionsAssert) assertThat(actual.getFsGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsGroup"));
  }


  /**
   * Navigates to the property groups so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> groups()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getGroups(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groups"));
    return answer;
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ObjectMetaAssert metadata()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Verifies that the actual SecurityContextConstraints's priority is equal to the given one.
   * @param priority the given priority to compare the actual SecurityContextConstraints's priority to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextConstraints's priority is not equal to the given one.
   */
  public S hasPriority(Integer priority) {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting priority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPriority = actual.getPriority();
    if (!Objects.areEqual(actualPriority, priority)) {
      failWithMessage(assertjErrorMessage, actual, priority, actualPriority);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property readOnlyRootFilesystem so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnlyRootFilesystem()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnlyRootFilesystem()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnlyRootFilesystem"));
  }


  /**
   * Navigates to the property requiredDropCapabilities so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> requiredDropCapabilities()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getRequiredDropCapabilities(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requiredDropCapabilities"));
    return answer;
  }


  /**
   * Navigates to the property runAsUser so that assertions can be done on it
   */
  public RunAsUserStrategyOptionsAssert runAsUser()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RunAsUserStrategyOptionsAssert) assertThat(actual.getRunAsUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runAsUser"));
  }


  /**
   * Navigates to the property seLinuxContext so that assertions can be done on it
   */
  public SELinuxContextStrategyOptionsAssert seLinuxContext()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SELinuxContextStrategyOptionsAssert) assertThat(actual.getSeLinuxContext()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "seLinuxContext"));
  }


  /**
   * Navigates to the property seccompProfiles so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> seccompProfiles()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getSeccompProfiles(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "seccompProfiles"));
    return answer;
  }


  /**
   * Navigates to the property supplementalGroups so that assertions can be done on it
   */
  public SupplementalGroupsStrategyOptionsAssert supplementalGroups()  {
    // check that actual SecurityContextConstraints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SupplementalGroupsStrategyOptionsAssert) assertThat(actual.getSupplementalGroups()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "supplementalGroups"));
  }


  /**
   * Navigates to the property users so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> users()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getUsers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "users"));
    return answer;
  }


  /**
   * Navigates to the property volumes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> volumes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getVolumes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"));
    return answer;
  }


}
