package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Status} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatusAssert<S extends AbstractStatusAssert<S, A>, A extends Status> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatusAssert}</code> to make assertions on actual Status.
   * @param actual the Status we want to make assertions on.
   */
  protected AbstractStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Verifies that the actual Status's code is equal to the given one.
   * @param code the given code to compare the actual Status's code to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's code is not equal to the given one.
   */
  public S hasCode(Integer code) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting code of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCode = actual.getCode();
    if (!Objects.areEqual(actualCode, code)) {
      failWithMessage(assertjErrorMessage, actual, code, actualCode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property details so that assertions can be done on it
   */
  public StatusDetailsAssert details()  {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (StatusDetailsAssert) assertThat(actual.getDetails()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "details"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ListMetaAssert metadata()  {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ListMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert status()  {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


}
