package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Volume} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeAssert<S extends AbstractVolumeAssert<S, A>, A extends Volume> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeAssert}</code> to make assertions on actual Volume.
   * @param actual the Volume we want to make assertions on.
   */
  protected AbstractVolumeAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property awsElasticBlockStore so that assertions can be done on it
   */
  public AWSElasticBlockStoreVolumeSourceAssert awsElasticBlockStore()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AWSElasticBlockStoreVolumeSourceAssert) assertThat(actual.getAwsElasticBlockStore()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "awsElasticBlockStore"));
  }


  /**
   * Navigates to the property azureDisk so that assertions can be done on it
   */
  public AzureDiskVolumeSourceAssert azureDisk()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AzureDiskVolumeSourceAssert) assertThat(actual.getAzureDisk()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "azureDisk"));
  }


  /**
   * Navigates to the property azureFile so that assertions can be done on it
   */
  public AzureFileVolumeSourceAssert azureFile()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AzureFileVolumeSourceAssert) assertThat(actual.getAzureFile()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "azureFile"));
  }


  /**
   * Navigates to the property cephfs so that assertions can be done on it
   */
  public CephFSVolumeSourceAssert cephfs()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CephFSVolumeSourceAssert) assertThat(actual.getCephfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cephfs"));
  }


  /**
   * Navigates to the property cinder so that assertions can be done on it
   */
  public CinderVolumeSourceAssert cinder()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CinderVolumeSourceAssert) assertThat(actual.getCinder()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cinder"));
  }


  /**
   * Navigates to the property configMap so that assertions can be done on it
   */
  public ConfigMapVolumeSourceAssert configMap()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapVolumeSourceAssert) assertThat(actual.getConfigMap()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMap"));
  }


  /**
   * Navigates to the property downwardAPI so that assertions can be done on it
   */
  public DownwardAPIVolumeSourceAssert downwardAPI()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DownwardAPIVolumeSourceAssert) assertThat(actual.getDownwardAPI()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "downwardAPI"));
  }


  /**
   * Navigates to the property emptyDir so that assertions can be done on it
   */
  public EmptyDirVolumeSourceAssert emptyDir()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EmptyDirVolumeSourceAssert) assertThat(actual.getEmptyDir()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "emptyDir"));
  }


  /**
   * Navigates to the property fc so that assertions can be done on it
   */
  public FCVolumeSourceAssert fc()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FCVolumeSourceAssert) assertThat(actual.getFc()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fc"));
  }


  /**
   * Navigates to the property flexVolume so that assertions can be done on it
   */
  public FlexVolumeSourceAssert flexVolume()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FlexVolumeSourceAssert) assertThat(actual.getFlexVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "flexVolume"));
  }


  /**
   * Navigates to the property flocker so that assertions can be done on it
   */
  public FlockerVolumeSourceAssert flocker()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FlockerVolumeSourceAssert) assertThat(actual.getFlocker()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "flocker"));
  }


  /**
   * Navigates to the property gcePersistentDisk so that assertions can be done on it
   */
  public GCEPersistentDiskVolumeSourceAssert gcePersistentDisk()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GCEPersistentDiskVolumeSourceAssert) assertThat(actual.getGcePersistentDisk()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gcePersistentDisk"));
  }


  /**
   * Navigates to the property gitRepo so that assertions can be done on it
   */
  public GitRepoVolumeSourceAssert gitRepo()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GitRepoVolumeSourceAssert) assertThat(actual.getGitRepo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gitRepo"));
  }


  /**
   * Navigates to the property glusterfs so that assertions can be done on it
   */
  public GlusterfsVolumeSourceAssert glusterfs()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GlusterfsVolumeSourceAssert) assertThat(actual.getGlusterfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "glusterfs"));
  }


  /**
   * Navigates to the property hostPath so that assertions can be done on it
   */
  public HostPathVolumeSourceAssert hostPath()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HostPathVolumeSourceAssert) assertThat(actual.getHostPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostPath"));
  }


  /**
   * Navigates to the property iscsi so that assertions can be done on it
   */
  public ISCSIVolumeSourceAssert iscsi()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ISCSIVolumeSourceAssert) assertThat(actual.getIscsi()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "iscsi"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public DeprecatedDownwardAPIVolumeSourceAssert metadata()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DeprecatedDownwardAPIVolumeSourceAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property nfs so that assertions can be done on it
   */
  public NFSVolumeSourceAssert nfs()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NFSVolumeSourceAssert) assertThat(actual.getNfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nfs"));
  }


  /**
   * Navigates to the property persistentVolumeClaim so that assertions can be done on it
   */
  public PersistentVolumeClaimVolumeSourceAssert persistentVolumeClaim()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeClaimVolumeSourceAssert) assertThat(actual.getPersistentVolumeClaim()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeClaim"));
  }


  /**
   * Navigates to the property photonPersistentDisk so that assertions can be done on it
   */
  public PhotonPersistentDiskVolumeSourceAssert photonPersistentDisk()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PhotonPersistentDiskVolumeSourceAssert) assertThat(actual.getPhotonPersistentDisk()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "photonPersistentDisk"));
  }


  /**
   * Navigates to the property quobyte so that assertions can be done on it
   */
  public QuobyteVolumeSourceAssert quobyte()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuobyteVolumeSourceAssert) assertThat(actual.getQuobyte()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "quobyte"));
  }


  /**
   * Navigates to the property rbd so that assertions can be done on it
   */
  public RBDVolumeSourceAssert rbd()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RBDVolumeSourceAssert) assertThat(actual.getRbd()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rbd"));
  }


  /**
   * Navigates to the property secret so that assertions can be done on it
   */
  public SecretVolumeSourceAssert secret()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretVolumeSourceAssert) assertThat(actual.getSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secret"));
  }


  /**
   * Navigates to the property vsphereVolume so that assertions can be done on it
   */
  public VsphereVirtualDiskVolumeSourceAssert vsphereVolume()  {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (VsphereVirtualDiskVolumeSourceAssert) assertThat(actual.getVsphereVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "vsphereVolume"));
  }


}
