package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DaemonSetSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDaemonSetSpecAssert<S extends AbstractDaemonSetSpecAssert<S, A>, A extends DaemonSetSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDaemonSetSpecAssert}</code> to make assertions on actual DaemonSetSpec.
   * @param actual the DaemonSetSpec we want to make assertions on.
   */
  protected AbstractDaemonSetSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LabelSelectorAssert selector()  {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LabelSelectorAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.PodTemplateSpecAssert template()  {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.PodTemplateSpecAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


}
