package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link IngressSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressSpecAssert<S extends AbstractIngressSpecAssert<S, A>, A extends IngressSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressSpecAssert}</code> to make assertions on actual IngressSpec.
   * @param actual the IngressSpec we want to make assertions on.
   */
  protected AbstractIngressSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual IngressSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property backend so that assertions can be done on it
   */
  public IngressBackendAssert backend()  {
    // check that actual IngressSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (IngressBackendAssert) assertThat(actual.getBackend()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "backend"));
  }


  /**
   * Navigates to the property rules so that assertions can be done on it
   */
  public NavigationListAssert<IngressRule, IngressRuleAssert> rules()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<IngressRule, IngressRuleAssert> assertFactory = new AssertFactory<IngressRule, IngressRuleAssert>() {
      public IngressRuleAssert createAssert(IngressRule t) {
        return (IngressRuleAssert) assertThat(t);
      }
    };
    NavigationListAssert<IngressRule, IngressRuleAssert> answer = new NavigationListAssert<IngressRule, IngressRuleAssert>(actual.getRules(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rules"));
    return answer;
  }


  /**
   * Navigates to the property tls so that assertions can be done on it
   */
  public NavigationListAssert<IngressTLS, IngressTLSAssert> tls()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<IngressTLS, IngressTLSAssert> assertFactory = new AssertFactory<IngressTLS, IngressTLSAssert>() {
      public IngressTLSAssert createAssert(IngressTLS t) {
        return (IngressTLSAssert) assertThat(t);
      }
    };
    NavigationListAssert<IngressTLS, IngressTLSAssert> answer = new NavigationListAssert<IngressTLS, IngressTLSAssert>(actual.getTls(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tls"));
    return answer;
  }


}
