package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildOutput} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildOutputAssert<S extends AbstractBuildOutputAssert<S, A>, A extends BuildOutput> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildOutputAssert}</code> to make assertions on actual BuildOutput.
   * @param actual the BuildOutput we want to make assertions on.
   */
  protected AbstractBuildOutputAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildOutput we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property imageLabels so that assertions can be done on it
   */
  public NavigationListAssert<ImageLabel, ImageLabelAssert> imageLabels()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ImageLabel, ImageLabelAssert> assertFactory = new AssertFactory<ImageLabel, ImageLabelAssert>() {
      public ImageLabelAssert createAssert(ImageLabel t) {
        return (ImageLabelAssert) assertThat(t);
      }
    };
    NavigationListAssert<ImageLabel, ImageLabelAssert> answer = new NavigationListAssert<ImageLabel, ImageLabelAssert>(actual.getImageLabels(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageLabels"));
    return answer;
  }


  /**
   * Navigates to the property pushSecret so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert pushSecret()  {
    // check that actual BuildOutput we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert) assertThat(actual.getPushSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pushSecret"));
  }


  /**
   * Navigates to the property to so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert to()  {
    // check that actual BuildOutput we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getTo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "to"));
  }


}
