package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageLayer} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageLayerAssert<S extends AbstractImageLayerAssert<S, A>, A extends ImageLayer> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageLayerAssert}</code> to make assertions on actual ImageLayer.
   * @param actual the ImageLayer we want to make assertions on.
   */
  protected AbstractImageLayerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageLayer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property mediaType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert mediaType()  {
    // check that actual ImageLayer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMediaType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "mediaType"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ImageLayer we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Verifies that the actual ImageLayer's size is equal to the given one.
   * @param size the given size to compare the actual ImageLayer's size to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageLayer's size is not equal to the given one.
   */
  public S hasSize(Long size) {
    // check that actual ImageLayer we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting size of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualSize = actual.getSize();
    if (!Objects.areEqual(actualSize, size)) {
      failWithMessage(assertjErrorMessage, actual, size, actualSize);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
