package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageStreamStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageStreamStatusAssert<S extends AbstractImageStreamStatusAssert<S, A>, A extends ImageStreamStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageStreamStatusAssert}</code> to make assertions on actual ImageStreamStatus.
   * @param actual the ImageStreamStatus we want to make assertions on.
   */
  protected AbstractImageStreamStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageStreamStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property dockerImageRepository so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerImageRepository()  {
    // check that actual ImageStreamStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerImageRepository()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerImageRepository"));
  }


  /**
   * Navigates to the property tags so that assertions can be done on it
   */
  public NavigationListAssert<NamedTagEventList, NamedTagEventListAssert> tags()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<NamedTagEventList, NamedTagEventListAssert> assertFactory = new AssertFactory<NamedTagEventList, NamedTagEventListAssert>() {
      public NamedTagEventListAssert createAssert(NamedTagEventList t) {
        return (NamedTagEventListAssert) assertThat(t);
      }
    };
    NavigationListAssert<NamedTagEventList, NamedTagEventListAssert> answer = new NavigationListAssert<NamedTagEventList, NamedTagEventListAssert>(actual.getTags(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tags"));
    return answer;
  }


}
