package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link LifecycleHook} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLifecycleHookAssert<S extends AbstractLifecycleHookAssert<S, A>, A extends LifecycleHook> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLifecycleHookAssert}</code> to make assertions on actual LifecycleHook.
   * @param actual the LifecycleHook we want to make assertions on.
   */
  protected AbstractLifecycleHookAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual LifecycleHook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property execNewPod so that assertions can be done on it
   */
  public ExecNewPodHookAssert execNewPod()  {
    // check that actual LifecycleHook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ExecNewPodHookAssert) assertThat(actual.getExecNewPod()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "execNewPod"));
  }


  /**
   * Navigates to the property failurePolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert failurePolicy()  {
    // check that actual LifecycleHook we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFailurePolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "failurePolicy"));
  }


  /**
   * Navigates to the property tagImages so that assertions can be done on it
   */
  public NavigationListAssert<TagImageHook, TagImageHookAssert> tagImages()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<TagImageHook, TagImageHookAssert> assertFactory = new AssertFactory<TagImageHook, TagImageHookAssert>() {
      public TagImageHookAssert createAssert(TagImageHook t) {
        return (TagImageHookAssert) assertThat(t);
      }
    };
    NavigationListAssert<TagImageHook, TagImageHookAssert> answer = new NavigationListAssert<TagImageHook, TagImageHookAssert>(actual.getTagImages(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tagImages"));
    return answer;
  }


}
