package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link NamedClusterRoleBinding} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedClusterRoleBindingAssert<S extends AbstractNamedClusterRoleBindingAssert<S, A>, A extends NamedClusterRoleBinding> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedClusterRoleBindingAssert}</code> to make assertions on actual NamedClusterRoleBinding.
   * @param actual the NamedClusterRoleBinding we want to make assertions on.
   */
  protected AbstractNamedClusterRoleBindingAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NamedClusterRoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual NamedClusterRoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property roleBinding so that assertions can be done on it
   */
  public ClusterRoleBindingAssert roleBinding()  {
    // check that actual NamedClusterRoleBinding we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ClusterRoleBindingAssert) assertThat(actual.getRoleBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleBinding"));
  }


}
