package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link NamedTagEventList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedTagEventListAssert<S extends AbstractNamedTagEventListAssert<S, A>, A extends NamedTagEventList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedTagEventListAssert}</code> to make assertions on actual NamedTagEventList.
   * @param actual the NamedTagEventList we want to make assertions on.
   */
  protected AbstractNamedTagEventListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NamedTagEventList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<TagEventCondition, TagEventConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<TagEventCondition, TagEventConditionAssert> assertFactory = new AssertFactory<TagEventCondition, TagEventConditionAssert>() {
      public TagEventConditionAssert createAssert(TagEventCondition t) {
        return (TagEventConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<TagEventCondition, TagEventConditionAssert> answer = new NavigationListAssert<TagEventCondition, TagEventConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<TagEvent, TagEventAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<TagEvent, TagEventAssert> assertFactory = new AssertFactory<TagEvent, TagEventAssert>() {
      public TagEventAssert createAssert(TagEvent t) {
        return (TagEventAssert) assertThat(t);
      }
    };
    NavigationListAssert<TagEvent, TagEventAssert> answer = new NavigationListAssert<TagEvent, TagEventAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


  /**
   * Navigates to the property tag so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert tag()  {
    // check that actual NamedTagEventList we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTag()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tag"));
  }


}
