package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link RouteSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRouteSpecAssert<S extends AbstractRouteSpecAssert<S, A>, A extends RouteSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRouteSpecAssert}</code> to make assertions on actual RouteSpec.
   * @param actual the RouteSpec we want to make assertions on.
   */
  protected AbstractRouteSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property alternateBackends so that assertions can be done on it
   */
  public NavigationListAssert<RouteTargetReference, RouteTargetReferenceAssert> alternateBackends()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<RouteTargetReference, RouteTargetReferenceAssert> assertFactory = new AssertFactory<RouteTargetReference, RouteTargetReferenceAssert>() {
      public RouteTargetReferenceAssert createAssert(RouteTargetReference t) {
        return (RouteTargetReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<RouteTargetReference, RouteTargetReferenceAssert> answer = new NavigationListAssert<RouteTargetReference, RouteTargetReferenceAssert>(actual.getAlternateBackends(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "alternateBackends"));
    return answer;
  }


  /**
   * Navigates to the property host so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert host()  {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHost()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "host"));
  }


  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


  /**
   * Navigates to the property port so that assertions can be done on it
   */
  public RoutePortAssert port()  {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RoutePortAssert) assertThat(actual.getPort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "port"));
  }


  /**
   * Navigates to the property tls so that assertions can be done on it
   */
  public TLSConfigAssert tls()  {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (TLSConfigAssert) assertThat(actual.getTls()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tls"));
  }


  /**
   * Navigates to the property to so that assertions can be done on it
   */
  public RouteTargetReferenceAssert to()  {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RouteTargetReferenceAssert) assertThat(actual.getTo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "to"));
  }


  /**
   * Navigates to the property wildcardPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert wildcardPolicy()  {
    // check that actual RouteSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getWildcardPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "wildcardPolicy"));
  }


}
