package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link SourceRevision} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSourceRevisionAssert<S extends AbstractSourceRevisionAssert<S, A>, A extends SourceRevision> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSourceRevisionAssert}</code> to make assertions on actual SourceRevision.
   * @param actual the SourceRevision we want to make assertions on.
   */
  protected AbstractSourceRevisionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SourceRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property git so that assertions can be done on it
   */
  public GitSourceRevisionAssert git()  {
    // check that actual SourceRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GitSourceRevisionAssert) assertThat(actual.getGit()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "git"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual SourceRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
