package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Template} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTemplateAssert<S extends AbstractTemplateAssert<S, A>, A extends Template> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTemplateAssert}</code> to make assertions on actual Template.
   * @param actual the Template we want to make assertions on.
   */
  protected AbstractTemplateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Template we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Template we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Template we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property labels so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert labels()  {
    // check that actual Template we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getLabels()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labels"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual Template we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property objects so that assertions can be done on it
   */
  public NavigationListAssert<io.fabric8.kubernetes.api.model.HasMetadata, io.fabric8.kubernetes.api.model.HasMetadataAssert> objects()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<io.fabric8.kubernetes.api.model.HasMetadata, io.fabric8.kubernetes.api.model.HasMetadataAssert> assertFactory = new AssertFactory<io.fabric8.kubernetes.api.model.HasMetadata, io.fabric8.kubernetes.api.model.HasMetadataAssert>() {
      public io.fabric8.kubernetes.api.model.HasMetadataAssert createAssert(io.fabric8.kubernetes.api.model.HasMetadata t) {
        return (io.fabric8.kubernetes.api.model.HasMetadataAssert) assertThat(t);
      }
    };
    NavigationListAssert<io.fabric8.kubernetes.api.model.HasMetadata, io.fabric8.kubernetes.api.model.HasMetadataAssert> answer = new NavigationListAssert<io.fabric8.kubernetes.api.model.HasMetadata, io.fabric8.kubernetes.api.model.HasMetadataAssert>(actual.getObjects(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "objects"));
    return answer;
  }


  /**
   * Navigates to the property parameters so that assertions can be done on it
   */
  public NavigationListAssert<Parameter, ParameterAssert> parameters()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<Parameter, ParameterAssert> assertFactory = new AssertFactory<Parameter, ParameterAssert>() {
      public ParameterAssert createAssert(Parameter t) {
        return (ParameterAssert) assertThat(t);
      }
    };
    NavigationListAssert<Parameter, ParameterAssert> answer = new NavigationListAssert<Parameter, ParameterAssert>(actual.getParameters(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "parameters"));
    return answer;
  }


}
