/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableEndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointAddressFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EndpointAddressBuilder
extends EndpointAddressFluent<EndpointAddressBuilder>
implements VisitableBuilder<EndpointAddress, EndpointAddressBuilder> {
    EndpointAddressFluent<?> fluent;

    public EndpointAddressBuilder() {
        this(new EndpointAddress());
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent) {
        this(fluent, new EndpointAddress());
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, EndpointAddress instance) {
        this.fluent = fluent;
        fluent.withIp(instance.getIp());
        fluent.withTargetRef(instance.getTargetRef());
    }

    public EndpointAddressBuilder(EndpointAddress instance) {
        this.fluent = this;
        this.withIp(instance.getIp());
        this.withTargetRef(instance.getTargetRef());
    }

    public EditableEndpointAddress build() {
        EditableEndpointAddress buildable = new EditableEndpointAddress(this.fluent.getIp(), this.fluent.getTargetRef());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointAddressBuilder that = (EndpointAddressBuilder)((Object)o);
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

