/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecretListFluent<T extends SecretListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    SecretList.ApiVersion apiVersion;
    List<VisitableBuilder<Secret, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public SecretList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(SecretList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public T addToItems(Secret ... items) {
        for (Secret item : items) {
            SecretBuilder builder = new SecretBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)((Object)this);
    }

    public T removeFromItems(Secret ... items) {
        for (Secret item : items) {
            SecretBuilder builder = new SecretBuilder(item);
            this._visitables.remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (T)((Object)this);
    }

    public List<Secret> getItems() {
        return this.build(this.items);
    }

    public T withItems(List<Secret> items) {
        this.items.clear();
        if (items != null) {
            for (Secret item : items) {
                this.addToItems(item);
            }
        }
        return (T)((Object)this);
    }

    public T withItems(Secret ... items) {
        this.items.clear();
        if (items != null) {
            for (Secret item : items) {
                this.addToItems(item);
            }
        }
        return (T)((Object)this);
    }

    public ItemsNested<T> addNewItem() {
        return new ItemsNested();
    }

    public ItemsNested<T> addNewItemLike(Secret item) {
        return new ItemsNested(item);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SecretListFluent that = (SecretListFluent)((Object)o);
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNested() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        public N and() {
            return (N)SecretListFluent.this.withMetadata(this.builder.build());
        }
    }

    public class ItemsNested<N>
    extends SecretFluent<ItemsNested<N>>
    implements Nested<N> {
        private final SecretBuilder builder;

        ItemsNested() {
            this.builder = new SecretBuilder(this);
        }

        ItemsNested(Secret item) {
            this.builder = new SecretBuilder(this, item);
        }

        public N endItem() {
            return this.and();
        }

        public N and() {
            return (N)SecretListFluent.this.addToItems(this.builder.build());
        }
    }
}

