/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecBuilder;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.ImageStreamStatusBuilder;
import io.fabric8.openshift.api.model.ImageStreamStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class ImageStreamFluent<T extends ImageStreamFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ImageStream.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ImageStreamSpec, ?> spec;
    VisitableBuilder<ImageStreamStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ImageStream.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ImageStream.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public ImageStreamSpec getSpec() {
        return this.spec != null ? (ImageStreamSpec)this.spec.build() : null;
    }

    public T withSpec(ImageStreamSpec spec) {
        if (spec != null) {
            this.spec = new ImageStreamSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)((Object)this);
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public SpecNested<T> withNewSpecLike(ImageStreamSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    public ImageStreamStatus getStatus() {
        return this.status != null ? (ImageStreamStatus)this.status.build() : null;
    }

    public T withStatus(ImageStreamStatus status) {
        if (status != null) {
            this.status = new ImageStreamStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)((Object)this);
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public StatusNested<T> withNewStatusLike(ImageStreamStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ImageStreamFluent that = (ImageStreamFluent)((Object)o);
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNested<N>
    extends ImageStreamStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final ImageStreamStatusBuilder builder;

        StatusNested() {
            this.builder = new ImageStreamStatusBuilder(this);
        }

        StatusNested(ImageStreamStatus item) {
            this.builder = new ImageStreamStatusBuilder(this, item);
        }

        public N endStatus() {
            return this.and();
        }

        public N and() {
            return (N)ImageStreamFluent.this.withStatus(this.builder.build());
        }
    }

    public class SpecNested<N>
    extends ImageStreamSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final ImageStreamSpecBuilder builder;

        SpecNested() {
            this.builder = new ImageStreamSpecBuilder(this);
        }

        SpecNested(ImageStreamSpec item) {
            this.builder = new ImageStreamSpecBuilder(this, item);
        }

        public N endSpec() {
            return this.and();
        }

        public N and() {
            return (N)ImageStreamFluent.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        public N and() {
            return (N)ImageStreamFluent.this.withMetadata(this.builder.build());
        }
    }
}

