package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStatusFluentAssert<S extends AbstractContainerStatusFluentAssert<S, A>, A extends ContainerStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStatusFluentAssert}</code> to make assertions on actual ContainerStatusFluent.
   * @param actual the ContainerStatusFluent we want to make assertions on.
   */
  protected AbstractContainerStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatusFluent's containerID is equal to the given one.
   * @param containerID the given containerID to compare the actual ContainerStatusFluent's containerID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatusFluent's containerID is not equal to the given one.
   */
  public S hasContainerID(String containerID) {
    // check that actual ContainerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContainerID = actual.getContainerID();
    if (!Objects.areEqual(actualContainerID, containerID)) {
      failWithMessage(assertjErrorMessage, actual, containerID, actualContainerID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatusFluent's image is equal to the given one.
   * @param image the given image to compare the actual ContainerStatusFluent's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatusFluent's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual ContainerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatusFluent's imageID is equal to the given one.
   * @param imageID the given imageID to compare the actual ContainerStatusFluent's imageID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatusFluent's imageID is not equal to the given one.
   */
  public S hasImageID(String imageID) {
    // check that actual ContainerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImageID = actual.getImageID();
    if (!Objects.areEqual(actualImageID, imageID)) {
      failWithMessage(assertjErrorMessage, actual, imageID, actualImageID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatusFluent's lastState is equal to the given one.
   * @param lastState the given lastState to compare the actual ContainerStatusFluent's lastState to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatusFluent's lastState is not equal to the given one.
   */
  public S hasLastState(ContainerState lastState) {
    // check that actual ContainerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected lastState of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerState actualLastState = actual.getLastState();
    if (!Objects.areEqual(actualLastState, lastState)) {
      failWithMessage(assertjErrorMessage, actual, lastState, actualLastState);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatusFluent's name is equal to the given one.
   * @param name the given name to compare the actual ContainerStatusFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatusFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ContainerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatusFluent's restartCount is equal to the given one.
   * @param restartCount the given restartCount to compare the actual ContainerStatusFluent's restartCount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatusFluent's restartCount is not equal to the given one.
   */
  public S hasRestartCount(Integer restartCount) {
    // check that actual ContainerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected restartCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRestartCount = actual.getRestartCount();
    if (!Objects.areEqual(actualRestartCount, restartCount)) {
      failWithMessage(assertjErrorMessage, actual, restartCount, actualRestartCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStatusFluent's state is equal to the given one.
   * @param state the given state to compare the actual ContainerStatusFluent's state to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStatusFluent's state is not equal to the given one.
   */
  public S hasState(ContainerState state) {
    // check that actual ContainerStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected state of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerState actualState = actual.getState();
    if (!Objects.areEqual(actualState, state)) {
      failWithMessage(assertjErrorMessage, actual, state, actualState);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
