package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ExecActionFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractExecActionFluentAssert<S extends AbstractExecActionFluentAssert<S, A>, A extends ExecActionFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractExecActionFluentAssert}</code> to make assertions on actual ExecActionFluent.
   * @param actual the ExecActionFluent we want to make assertions on.
   */
  protected AbstractExecActionFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ExecActionFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ExecActionFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ExecActionFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ExecActionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecActionFluent's command contains the given String elements.
   * @param command the given elements that should be contained in actual ExecActionFluent's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecActionFluent's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual ExecActionFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) throw new AssertionError("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecActionFluent has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecActionFluent's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual ExecActionFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
