package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HostPathVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHostPathVolumeSourceAssert<S extends AbstractHostPathVolumeSourceAssert<S, A>, A extends HostPathVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHostPathVolumeSourceAssert}</code> to make assertions on actual HostPathVolumeSource.
   * @param actual the HostPathVolumeSource we want to make assertions on.
   */
  protected AbstractHostPathVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HostPathVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual HostPathVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HostPathVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual HostPathVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HostPathVolumeSource's path is equal to the given one.
   * @param path the given path to compare the actual HostPathVolumeSource's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HostPathVolumeSource's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual HostPathVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
