package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KubeSchemaFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubeSchemaFluentImplAssert<S extends AbstractKubeSchemaFluentImplAssert<S, A>, A extends KubeSchemaFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubeSchemaFluentImplAssert}</code> to make assertions on actual KubeSchemaFluentImpl.
   * @param actual the KubeSchemaFluentImpl we want to make assertions on.
   */
  protected AbstractKubeSchemaFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual KubeSchemaFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's baseKubernetesList is equal to the given one.
   * @param baseKubernetesList the given baseKubernetesList to compare the actual KubeSchemaFluentImpl's baseKubernetesList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's baseKubernetesList is not equal to the given one.
   */
  public S hasBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected baseKubernetesList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BaseKubernetesList actualBaseKubernetesList = actual.getBaseKubernetesList();
    if (!Objects.areEqual(actualBaseKubernetesList, baseKubernetesList)) {
      failWithMessage(assertjErrorMessage, actual, baseKubernetesList, actualBaseKubernetesList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's buildConfigList is equal to the given one.
   * @param buildConfigList the given buildConfigList to compare the actual KubeSchemaFluentImpl's buildConfigList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's buildConfigList is not equal to the given one.
   */
  public S hasBuildConfigList(io.fabric8.openshift.api.model.BuildConfigList buildConfigList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected buildConfigList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildConfigList actualBuildConfigList = actual.getBuildConfigList();
    if (!Objects.areEqual(actualBuildConfigList, buildConfigList)) {
      failWithMessage(assertjErrorMessage, actual, buildConfigList, actualBuildConfigList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's buildList is equal to the given one.
   * @param buildList the given buildList to compare the actual KubeSchemaFluentImpl's buildList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's buildList is not equal to the given one.
   */
  public S hasBuildList(io.fabric8.openshift.api.model.BuildList buildList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected buildList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildList actualBuildList = actual.getBuildList();
    if (!Objects.areEqual(actualBuildList, buildList)) {
      failWithMessage(assertjErrorMessage, actual, buildList, actualBuildList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's buildRequest is equal to the given one.
   * @param buildRequest the given buildRequest to compare the actual KubeSchemaFluentImpl's buildRequest to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's buildRequest is not equal to the given one.
   */
  public S hasBuildRequest(io.fabric8.openshift.api.model.BuildRequest buildRequest) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected buildRequest of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildRequest actualBuildRequest = actual.getBuildRequest();
    if (!Objects.areEqual(actualBuildRequest, buildRequest)) {
      failWithMessage(assertjErrorMessage, actual, buildRequest, actualBuildRequest);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's clusterPolicy is equal to the given one.
   * @param clusterPolicy the given clusterPolicy to compare the actual KubeSchemaFluentImpl's clusterPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's clusterPolicy is not equal to the given one.
   */
  public S hasClusterPolicy(io.fabric8.openshift.api.model.ClusterPolicy clusterPolicy) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clusterPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterPolicy actualClusterPolicy = actual.getClusterPolicy();
    if (!Objects.areEqual(actualClusterPolicy, clusterPolicy)) {
      failWithMessage(assertjErrorMessage, actual, clusterPolicy, actualClusterPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's clusterPolicyBinding is equal to the given one.
   * @param clusterPolicyBinding the given clusterPolicyBinding to compare the actual KubeSchemaFluentImpl's clusterPolicyBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's clusterPolicyBinding is not equal to the given one.
   */
  public S hasClusterPolicyBinding(io.fabric8.openshift.api.model.ClusterPolicyBinding clusterPolicyBinding) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clusterPolicyBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterPolicyBinding actualClusterPolicyBinding = actual.getClusterPolicyBinding();
    if (!Objects.areEqual(actualClusterPolicyBinding, clusterPolicyBinding)) {
      failWithMessage(assertjErrorMessage, actual, clusterPolicyBinding, actualClusterPolicyBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's clusterPolicyBindingList is equal to the given one.
   * @param clusterPolicyBindingList the given clusterPolicyBindingList to compare the actual KubeSchemaFluentImpl's clusterPolicyBindingList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's clusterPolicyBindingList is not equal to the given one.
   */
  public S hasClusterPolicyBindingList(io.fabric8.openshift.api.model.ClusterPolicyBindingList clusterPolicyBindingList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clusterPolicyBindingList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterPolicyBindingList actualClusterPolicyBindingList = actual.getClusterPolicyBindingList();
    if (!Objects.areEqual(actualClusterPolicyBindingList, clusterPolicyBindingList)) {
      failWithMessage(assertjErrorMessage, actual, clusterPolicyBindingList, actualClusterPolicyBindingList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's clusterPolicyList is equal to the given one.
   * @param clusterPolicyList the given clusterPolicyList to compare the actual KubeSchemaFluentImpl's clusterPolicyList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's clusterPolicyList is not equal to the given one.
   */
  public S hasClusterPolicyList(io.fabric8.openshift.api.model.ClusterPolicyList clusterPolicyList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clusterPolicyList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterPolicyList actualClusterPolicyList = actual.getClusterPolicyList();
    if (!Objects.areEqual(actualClusterPolicyList, clusterPolicyList)) {
      failWithMessage(assertjErrorMessage, actual, clusterPolicyList, actualClusterPolicyList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's clusterRoleBinding is equal to the given one.
   * @param clusterRoleBinding the given clusterRoleBinding to compare the actual KubeSchemaFluentImpl's clusterRoleBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's clusterRoleBinding is not equal to the given one.
   */
  public S hasClusterRoleBinding(io.fabric8.openshift.api.model.ClusterRoleBinding clusterRoleBinding) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clusterRoleBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterRoleBinding actualClusterRoleBinding = actual.getClusterRoleBinding();
    if (!Objects.areEqual(actualClusterRoleBinding, clusterRoleBinding)) {
      failWithMessage(assertjErrorMessage, actual, clusterRoleBinding, actualClusterRoleBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's clusterRoleBindingList is equal to the given one.
   * @param clusterRoleBindingList the given clusterRoleBindingList to compare the actual KubeSchemaFluentImpl's clusterRoleBindingList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's clusterRoleBindingList is not equal to the given one.
   */
  public S hasClusterRoleBindingList(io.fabric8.openshift.api.model.ClusterRoleBindingList clusterRoleBindingList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected clusterRoleBindingList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterRoleBindingList actualClusterRoleBindingList = actual.getClusterRoleBindingList();
    if (!Objects.areEqual(actualClusterRoleBindingList, clusterRoleBindingList)) {
      failWithMessage(assertjErrorMessage, actual, clusterRoleBindingList, actualClusterRoleBindingList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's config is equal to the given one.
   * @param config the given config to compare the actual KubeSchemaFluentImpl's config to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's config is not equal to the given one.
   */
  public S hasConfig(Config config) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected config of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Config actualConfig = actual.getConfig();
    if (!Objects.areEqual(actualConfig, config)) {
      failWithMessage(assertjErrorMessage, actual, config, actualConfig);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's containerStatus is equal to the given one.
   * @param containerStatus the given containerStatus to compare the actual KubeSchemaFluentImpl's containerStatus to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's containerStatus is not equal to the given one.
   */
  public S hasContainerStatus(ContainerStatus containerStatus) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerStatus of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerStatus actualContainerStatus = actual.getContainerStatus();
    if (!Objects.areEqual(actualContainerStatus, containerStatus)) {
      failWithMessage(assertjErrorMessage, actual, containerStatus, actualContainerStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's deploymentConfigList is equal to the given one.
   * @param deploymentConfigList the given deploymentConfigList to compare the actual KubeSchemaFluentImpl's deploymentConfigList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's deploymentConfigList is not equal to the given one.
   */
  public S hasDeploymentConfigList(io.fabric8.openshift.api.model.DeploymentConfigList deploymentConfigList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected deploymentConfigList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.DeploymentConfigList actualDeploymentConfigList = actual.getDeploymentConfigList();
    if (!Objects.areEqual(actualDeploymentConfigList, deploymentConfigList)) {
      failWithMessage(assertjErrorMessage, actual, deploymentConfigList, actualDeploymentConfigList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's endpoints is equal to the given one.
   * @param endpoints the given endpoints to compare the actual KubeSchemaFluentImpl's endpoints to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's endpoints is not equal to the given one.
   */
  public S hasEndpoints(Endpoints endpoints) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected endpoints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Endpoints actualEndpoints = actual.getEndpoints();
    if (!Objects.areEqual(actualEndpoints, endpoints)) {
      failWithMessage(assertjErrorMessage, actual, endpoints, actualEndpoints);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's endpointsList is equal to the given one.
   * @param endpointsList the given endpointsList to compare the actual KubeSchemaFluentImpl's endpointsList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's endpointsList is not equal to the given one.
   */
  public S hasEndpointsList(EndpointsList endpointsList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected endpointsList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EndpointsList actualEndpointsList = actual.getEndpointsList();
    if (!Objects.areEqual(actualEndpointsList, endpointsList)) {
      failWithMessage(assertjErrorMessage, actual, endpointsList, actualEndpointsList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's envVar is equal to the given one.
   * @param envVar the given envVar to compare the actual KubeSchemaFluentImpl's envVar to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's envVar is not equal to the given one.
   */
  public S hasEnvVar(EnvVar envVar) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected envVar of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EnvVar actualEnvVar = actual.getEnvVar();
    if (!Objects.areEqual(actualEnvVar, envVar)) {
      failWithMessage(assertjErrorMessage, actual, envVar, actualEnvVar);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's eventList is equal to the given one.
   * @param eventList the given eventList to compare the actual KubeSchemaFluentImpl's eventList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's eventList is not equal to the given one.
   */
  public S hasEventList(EventList eventList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected eventList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EventList actualEventList = actual.getEventList();
    if (!Objects.areEqual(actualEventList, eventList)) {
      failWithMessage(assertjErrorMessage, actual, eventList, actualEventList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's group is equal to the given one.
   * @param group the given group to compare the actual KubeSchemaFluentImpl's group to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's group is not equal to the given one.
   */
  public S hasGroup(io.fabric8.openshift.api.model.Group group) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected group of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Group actualGroup = actual.getGroup();
    if (!Objects.areEqual(actualGroup, group)) {
      failWithMessage(assertjErrorMessage, actual, group, actualGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's groupList is equal to the given one.
   * @param groupList the given groupList to compare the actual KubeSchemaFluentImpl's groupList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's groupList is not equal to the given one.
   */
  public S hasGroupList(io.fabric8.openshift.api.model.GroupList groupList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected groupList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.GroupList actualGroupList = actual.getGroupList();
    if (!Objects.areEqual(actualGroupList, groupList)) {
      failWithMessage(assertjErrorMessage, actual, groupList, actualGroupList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's identity is equal to the given one.
   * @param identity the given identity to compare the actual KubeSchemaFluentImpl's identity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's identity is not equal to the given one.
   */
  public S hasIdentity(io.fabric8.openshift.api.model.Identity identity) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected identity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Identity actualIdentity = actual.getIdentity();
    if (!Objects.areEqual(actualIdentity, identity)) {
      failWithMessage(assertjErrorMessage, actual, identity, actualIdentity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's identityList is equal to the given one.
   * @param identityList the given identityList to compare the actual KubeSchemaFluentImpl's identityList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's identityList is not equal to the given one.
   */
  public S hasIdentityList(io.fabric8.openshift.api.model.IdentityList identityList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected identityList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.IdentityList actualIdentityList = actual.getIdentityList();
    if (!Objects.areEqual(actualIdentityList, identityList)) {
      failWithMessage(assertjErrorMessage, actual, identityList, actualIdentityList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's imageList is equal to the given one.
   * @param imageList the given imageList to compare the actual KubeSchemaFluentImpl's imageList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's imageList is not equal to the given one.
   */
  public S hasImageList(io.fabric8.openshift.api.model.ImageList imageList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ImageList actualImageList = actual.getImageList();
    if (!Objects.areEqual(actualImageList, imageList)) {
      failWithMessage(assertjErrorMessage, actual, imageList, actualImageList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's imageStreamList is equal to the given one.
   * @param imageStreamList the given imageStreamList to compare the actual KubeSchemaFluentImpl's imageStreamList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's imageStreamList is not equal to the given one.
   */
  public S hasImageStreamList(io.fabric8.openshift.api.model.ImageStreamList imageStreamList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageStreamList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ImageStreamList actualImageStreamList = actual.getImageStreamList();
    if (!Objects.areEqual(actualImageStreamList, imageStreamList)) {
      failWithMessage(assertjErrorMessage, actual, imageStreamList, actualImageStreamList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's localSubjectAccessReview is equal to the given one.
   * @param localSubjectAccessReview the given localSubjectAccessReview to compare the actual KubeSchemaFluentImpl's localSubjectAccessReview to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's localSubjectAccessReview is not equal to the given one.
   */
  public S hasLocalSubjectAccessReview(io.fabric8.openshift.api.model.LocalSubjectAccessReview localSubjectAccessReview) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected localSubjectAccessReview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.LocalSubjectAccessReview actualLocalSubjectAccessReview = actual.getLocalSubjectAccessReview();
    if (!Objects.areEqual(actualLocalSubjectAccessReview, localSubjectAccessReview)) {
      failWithMessage(assertjErrorMessage, actual, localSubjectAccessReview, actualLocalSubjectAccessReview);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual KubeSchemaFluentImpl's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's namespace is not equal to the given one.
   */
  public S hasNamespace(Namespace namespace) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Namespace actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's namespaceList is equal to the given one.
   * @param namespaceList the given namespaceList to compare the actual KubeSchemaFluentImpl's namespaceList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's namespaceList is not equal to the given one.
   */
  public S hasNamespaceList(NamespaceList namespaceList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespaceList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NamespaceList actualNamespaceList = actual.getNamespaceList();
    if (!Objects.areEqual(actualNamespaceList, namespaceList)) {
      failWithMessage(assertjErrorMessage, actual, namespaceList, actualNamespaceList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's node is equal to the given one.
   * @param node the given node to compare the actual KubeSchemaFluentImpl's node to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's node is not equal to the given one.
   */
  public S hasNode(Node node) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected node of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Node actualNode = actual.getNode();
    if (!Objects.areEqual(actualNode, node)) {
      failWithMessage(assertjErrorMessage, actual, node, actualNode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's nodeList is equal to the given one.
   * @param nodeList the given nodeList to compare the actual KubeSchemaFluentImpl's nodeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's nodeList is not equal to the given one.
   */
  public S hasNodeList(NodeList nodeList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nodeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeList actualNodeList = actual.getNodeList();
    if (!Objects.areEqual(actualNodeList, nodeList)) {
      failWithMessage(assertjErrorMessage, actual, nodeList, actualNodeList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's oAuthAccessToken is equal to the given one.
   * @param oAuthAccessToken the given oAuthAccessToken to compare the actual KubeSchemaFluentImpl's oAuthAccessToken to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's oAuthAccessToken is not equal to the given one.
   */
  public S hasOAuthAccessToken(io.fabric8.openshift.api.model.OAuthAccessToken oAuthAccessToken) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthAccessToken of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAccessToken actualOAuthAccessToken = actual.getOAuthAccessToken();
    if (!Objects.areEqual(actualOAuthAccessToken, oAuthAccessToken)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAccessToken, actualOAuthAccessToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's oAuthAccessTokenList is equal to the given one.
   * @param oAuthAccessTokenList the given oAuthAccessTokenList to compare the actual KubeSchemaFluentImpl's oAuthAccessTokenList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's oAuthAccessTokenList is not equal to the given one.
   */
  public S hasOAuthAccessTokenList(io.fabric8.openshift.api.model.OAuthAccessTokenList oAuthAccessTokenList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthAccessTokenList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAccessTokenList actualOAuthAccessTokenList = actual.getOAuthAccessTokenList();
    if (!Objects.areEqual(actualOAuthAccessTokenList, oAuthAccessTokenList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAccessTokenList, actualOAuthAccessTokenList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's oAuthAuthorizeToken is equal to the given one.
   * @param oAuthAuthorizeToken the given oAuthAuthorizeToken to compare the actual KubeSchemaFluentImpl's oAuthAuthorizeToken to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's oAuthAuthorizeToken is not equal to the given one.
   */
  public S hasOAuthAuthorizeToken(io.fabric8.openshift.api.model.OAuthAuthorizeToken oAuthAuthorizeToken) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthAuthorizeToken of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAuthorizeToken actualOAuthAuthorizeToken = actual.getOAuthAuthorizeToken();
    if (!Objects.areEqual(actualOAuthAuthorizeToken, oAuthAuthorizeToken)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAuthorizeToken, actualOAuthAuthorizeToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's oAuthAuthorizeTokenList is equal to the given one.
   * @param oAuthAuthorizeTokenList the given oAuthAuthorizeTokenList to compare the actual KubeSchemaFluentImpl's oAuthAuthorizeTokenList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's oAuthAuthorizeTokenList is not equal to the given one.
   */
  public S hasOAuthAuthorizeTokenList(io.fabric8.openshift.api.model.OAuthAuthorizeTokenList oAuthAuthorizeTokenList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthAuthorizeTokenList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenList actualOAuthAuthorizeTokenList = actual.getOAuthAuthorizeTokenList();
    if (!Objects.areEqual(actualOAuthAuthorizeTokenList, oAuthAuthorizeTokenList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAuthorizeTokenList, actualOAuthAuthorizeTokenList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's oAuthClient is equal to the given one.
   * @param oAuthClient the given oAuthClient to compare the actual KubeSchemaFluentImpl's oAuthClient to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's oAuthClient is not equal to the given one.
   */
  public S hasOAuthClient(io.fabric8.openshift.api.model.OAuthClient oAuthClient) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthClient of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClient actualOAuthClient = actual.getOAuthClient();
    if (!Objects.areEqual(actualOAuthClient, oAuthClient)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClient, actualOAuthClient);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's oAuthClientAuthorization is equal to the given one.
   * @param oAuthClientAuthorization the given oAuthClientAuthorization to compare the actual KubeSchemaFluentImpl's oAuthClientAuthorization to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's oAuthClientAuthorization is not equal to the given one.
   */
  public S hasOAuthClientAuthorization(io.fabric8.openshift.api.model.OAuthClientAuthorization oAuthClientAuthorization) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthClientAuthorization of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientAuthorization actualOAuthClientAuthorization = actual.getOAuthClientAuthorization();
    if (!Objects.areEqual(actualOAuthClientAuthorization, oAuthClientAuthorization)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientAuthorization, actualOAuthClientAuthorization);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's oAuthClientAuthorizationList is equal to the given one.
   * @param oAuthClientAuthorizationList the given oAuthClientAuthorizationList to compare the actual KubeSchemaFluentImpl's oAuthClientAuthorizationList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's oAuthClientAuthorizationList is not equal to the given one.
   */
  public S hasOAuthClientAuthorizationList(io.fabric8.openshift.api.model.OAuthClientAuthorizationList oAuthClientAuthorizationList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthClientAuthorizationList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientAuthorizationList actualOAuthClientAuthorizationList = actual.getOAuthClientAuthorizationList();
    if (!Objects.areEqual(actualOAuthClientAuthorizationList, oAuthClientAuthorizationList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientAuthorizationList, actualOAuthClientAuthorizationList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's oAuthClientList is equal to the given one.
   * @param oAuthClientList the given oAuthClientList to compare the actual KubeSchemaFluentImpl's oAuthClientList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's oAuthClientList is not equal to the given one.
   */
  public S hasOAuthClientList(io.fabric8.openshift.api.model.OAuthClientList oAuthClientList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthClientList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientList actualOAuthClientList = actual.getOAuthClientList();
    if (!Objects.areEqual(actualOAuthClientList, oAuthClientList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientList, actualOAuthClientList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's objectMeta is equal to the given one.
   * @param objectMeta the given objectMeta to compare the actual KubeSchemaFluentImpl's objectMeta to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's objectMeta is not equal to the given one.
   */
  public S hasObjectMeta(ObjectMeta objectMeta) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected objectMeta of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualObjectMeta = actual.getObjectMeta();
    if (!Objects.areEqual(actualObjectMeta, objectMeta)) {
      failWithMessage(assertjErrorMessage, actual, objectMeta, actualObjectMeta);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's persistentVolume is equal to the given one.
   * @param persistentVolume the given persistentVolume to compare the actual KubeSchemaFluentImpl's persistentVolume to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's persistentVolume is not equal to the given one.
   */
  public S hasPersistentVolume(PersistentVolume persistentVolume) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected persistentVolume of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolume actualPersistentVolume = actual.getPersistentVolume();
    if (!Objects.areEqual(actualPersistentVolume, persistentVolume)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolume, actualPersistentVolume);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's persistentVolumeClaim is equal to the given one.
   * @param persistentVolumeClaim the given persistentVolumeClaim to compare the actual KubeSchemaFluentImpl's persistentVolumeClaim to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's persistentVolumeClaim is not equal to the given one.
   */
  public S hasPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected persistentVolumeClaim of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaim actualPersistentVolumeClaim = actual.getPersistentVolumeClaim();
    if (!Objects.areEqual(actualPersistentVolumeClaim, persistentVolumeClaim)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeClaim, actualPersistentVolumeClaim);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's persistentVolumeClaimList is equal to the given one.
   * @param persistentVolumeClaimList the given persistentVolumeClaimList to compare the actual KubeSchemaFluentImpl's persistentVolumeClaimList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's persistentVolumeClaimList is not equal to the given one.
   */
  public S hasPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected persistentVolumeClaimList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaimList actualPersistentVolumeClaimList = actual.getPersistentVolumeClaimList();
    if (!Objects.areEqual(actualPersistentVolumeClaimList, persistentVolumeClaimList)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeClaimList, actualPersistentVolumeClaimList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's persistentVolumeList is equal to the given one.
   * @param persistentVolumeList the given persistentVolumeList to compare the actual KubeSchemaFluentImpl's persistentVolumeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's persistentVolumeList is not equal to the given one.
   */
  public S hasPersistentVolumeList(PersistentVolumeList persistentVolumeList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected persistentVolumeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeList actualPersistentVolumeList = actual.getPersistentVolumeList();
    if (!Objects.areEqual(actualPersistentVolumeList, persistentVolumeList)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeList, actualPersistentVolumeList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's podList is equal to the given one.
   * @param podList the given podList to compare the actual KubeSchemaFluentImpl's podList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's podList is not equal to the given one.
   */
  public S hasPodList(PodList podList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodList actualPodList = actual.getPodList();
    if (!Objects.areEqual(actualPodList, podList)) {
      failWithMessage(assertjErrorMessage, actual, podList, actualPodList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's policy is equal to the given one.
   * @param policy the given policy to compare the actual KubeSchemaFluentImpl's policy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's policy is not equal to the given one.
   */
  public S hasPolicy(io.fabric8.openshift.api.model.Policy policy) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected policy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Policy actualPolicy = actual.getPolicy();
    if (!Objects.areEqual(actualPolicy, policy)) {
      failWithMessage(assertjErrorMessage, actual, policy, actualPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's policyBinding is equal to the given one.
   * @param policyBinding the given policyBinding to compare the actual KubeSchemaFluentImpl's policyBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's policyBinding is not equal to the given one.
   */
  public S hasPolicyBinding(io.fabric8.openshift.api.model.PolicyBinding policyBinding) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected policyBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.PolicyBinding actualPolicyBinding = actual.getPolicyBinding();
    if (!Objects.areEqual(actualPolicyBinding, policyBinding)) {
      failWithMessage(assertjErrorMessage, actual, policyBinding, actualPolicyBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's policyBindingList is equal to the given one.
   * @param policyBindingList the given policyBindingList to compare the actual KubeSchemaFluentImpl's policyBindingList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's policyBindingList is not equal to the given one.
   */
  public S hasPolicyBindingList(io.fabric8.openshift.api.model.PolicyBindingList policyBindingList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected policyBindingList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.PolicyBindingList actualPolicyBindingList = actual.getPolicyBindingList();
    if (!Objects.areEqual(actualPolicyBindingList, policyBindingList)) {
      failWithMessage(assertjErrorMessage, actual, policyBindingList, actualPolicyBindingList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's policyList is equal to the given one.
   * @param policyList the given policyList to compare the actual KubeSchemaFluentImpl's policyList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's policyList is not equal to the given one.
   */
  public S hasPolicyList(io.fabric8.openshift.api.model.PolicyList policyList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected policyList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.PolicyList actualPolicyList = actual.getPolicyList();
    if (!Objects.areEqual(actualPolicyList, policyList)) {
      failWithMessage(assertjErrorMessage, actual, policyList, actualPolicyList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's project is equal to the given one.
   * @param project the given project to compare the actual KubeSchemaFluentImpl's project to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's project is not equal to the given one.
   */
  public S hasProject(io.fabric8.openshift.api.model.Project project) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected project of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Project actualProject = actual.getProject();
    if (!Objects.areEqual(actualProject, project)) {
      failWithMessage(assertjErrorMessage, actual, project, actualProject);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's projectList is equal to the given one.
   * @param projectList the given projectList to compare the actual KubeSchemaFluentImpl's projectList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's projectList is not equal to the given one.
   */
  public S hasProjectList(io.fabric8.openshift.api.model.ProjectList projectList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected projectList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ProjectList actualProjectList = actual.getProjectList();
    if (!Objects.areEqual(actualProjectList, projectList)) {
      failWithMessage(assertjErrorMessage, actual, projectList, actualProjectList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's projectRequest is equal to the given one.
   * @param projectRequest the given projectRequest to compare the actual KubeSchemaFluentImpl's projectRequest to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's projectRequest is not equal to the given one.
   */
  public S hasProjectRequest(io.fabric8.openshift.api.model.ProjectRequest projectRequest) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected projectRequest of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ProjectRequest actualProjectRequest = actual.getProjectRequest();
    if (!Objects.areEqual(actualProjectRequest, projectRequest)) {
      failWithMessage(assertjErrorMessage, actual, projectRequest, actualProjectRequest);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's quantity is equal to the given one.
   * @param quantity the given quantity to compare the actual KubeSchemaFluentImpl's quantity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's quantity is not equal to the given one.
   */
  public S hasQuantity(Quantity quantity) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected quantity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Quantity actualQuantity = actual.getQuantity();
    if (!Objects.areEqual(actualQuantity, quantity)) {
      failWithMessage(assertjErrorMessage, actual, quantity, actualQuantity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's replicationControllerList is equal to the given one.
   * @param replicationControllerList the given replicationControllerList to compare the actual KubeSchemaFluentImpl's replicationControllerList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's replicationControllerList is not equal to the given one.
   */
  public S hasReplicationControllerList(ReplicationControllerList replicationControllerList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicationControllerList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ReplicationControllerList actualReplicationControllerList = actual.getReplicationControllerList();
    if (!Objects.areEqual(actualReplicationControllerList, replicationControllerList)) {
      failWithMessage(assertjErrorMessage, actual, replicationControllerList, actualReplicationControllerList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's resourceQuota is equal to the given one.
   * @param resourceQuota the given resourceQuota to compare the actual KubeSchemaFluentImpl's resourceQuota to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's resourceQuota is not equal to the given one.
   */
  public S hasResourceQuota(ResourceQuota resourceQuota) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceQuota of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ResourceQuota actualResourceQuota = actual.getResourceQuota();
    if (!Objects.areEqual(actualResourceQuota, resourceQuota)) {
      failWithMessage(assertjErrorMessage, actual, resourceQuota, actualResourceQuota);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's resourceQuotaList is equal to the given one.
   * @param resourceQuotaList the given resourceQuotaList to compare the actual KubeSchemaFluentImpl's resourceQuotaList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's resourceQuotaList is not equal to the given one.
   */
  public S hasResourceQuotaList(ResourceQuotaList resourceQuotaList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceQuotaList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ResourceQuotaList actualResourceQuotaList = actual.getResourceQuotaList();
    if (!Objects.areEqual(actualResourceQuotaList, resourceQuotaList)) {
      failWithMessage(assertjErrorMessage, actual, resourceQuotaList, actualResourceQuotaList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's role is equal to the given one.
   * @param role the given role to compare the actual KubeSchemaFluentImpl's role to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's role is not equal to the given one.
   */
  public S hasRole(io.fabric8.openshift.api.model.Role role) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected role of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Role actualRole = actual.getRole();
    if (!Objects.areEqual(actualRole, role)) {
      failWithMessage(assertjErrorMessage, actual, role, actualRole);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's roleBinding is equal to the given one.
   * @param roleBinding the given roleBinding to compare the actual KubeSchemaFluentImpl's roleBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's roleBinding is not equal to the given one.
   */
  public S hasRoleBinding(io.fabric8.openshift.api.model.RoleBinding roleBinding) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected roleBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RoleBinding actualRoleBinding = actual.getRoleBinding();
    if (!Objects.areEqual(actualRoleBinding, roleBinding)) {
      failWithMessage(assertjErrorMessage, actual, roleBinding, actualRoleBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's roleBindingList is equal to the given one.
   * @param roleBindingList the given roleBindingList to compare the actual KubeSchemaFluentImpl's roleBindingList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's roleBindingList is not equal to the given one.
   */
  public S hasRoleBindingList(io.fabric8.openshift.api.model.RoleBindingList roleBindingList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected roleBindingList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RoleBindingList actualRoleBindingList = actual.getRoleBindingList();
    if (!Objects.areEqual(actualRoleBindingList, roleBindingList)) {
      failWithMessage(assertjErrorMessage, actual, roleBindingList, actualRoleBindingList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's roleList is equal to the given one.
   * @param roleList the given roleList to compare the actual KubeSchemaFluentImpl's roleList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's roleList is not equal to the given one.
   */
  public S hasRoleList(io.fabric8.openshift.api.model.RoleList roleList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected roleList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RoleList actualRoleList = actual.getRoleList();
    if (!Objects.areEqual(actualRoleList, roleList)) {
      failWithMessage(assertjErrorMessage, actual, roleList, actualRoleList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's rootPaths is equal to the given one.
   * @param rootPaths the given rootPaths to compare the actual KubeSchemaFluentImpl's rootPaths to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's rootPaths is not equal to the given one.
   */
  public S hasRootPaths(RootPaths rootPaths) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected rootPaths of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RootPaths actualRootPaths = actual.getRootPaths();
    if (!Objects.areEqual(actualRootPaths, rootPaths)) {
      failWithMessage(assertjErrorMessage, actual, rootPaths, actualRootPaths);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's routeList is equal to the given one.
   * @param routeList the given routeList to compare the actual KubeSchemaFluentImpl's routeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's routeList is not equal to the given one.
   */
  public S hasRouteList(io.fabric8.openshift.api.model.RouteList routeList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected routeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RouteList actualRouteList = actual.getRouteList();
    if (!Objects.areEqual(actualRouteList, routeList)) {
      failWithMessage(assertjErrorMessage, actual, routeList, actualRouteList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's secret is equal to the given one.
   * @param secret the given secret to compare the actual KubeSchemaFluentImpl's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's secret is not equal to the given one.
   */
  public S hasSecret(Secret secret) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Secret actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's secretList is equal to the given one.
   * @param secretList the given secretList to compare the actual KubeSchemaFluentImpl's secretList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's secretList is not equal to the given one.
   */
  public S hasSecretList(SecretList secretList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secretList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecretList actualSecretList = actual.getSecretList();
    if (!Objects.areEqual(actualSecretList, secretList)) {
      failWithMessage(assertjErrorMessage, actual, secretList, actualSecretList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's securityContextConstraints is equal to the given one.
   * @param securityContextConstraints the given securityContextConstraints to compare the actual KubeSchemaFluentImpl's securityContextConstraints to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's securityContextConstraints is not equal to the given one.
   */
  public S hasSecurityContextConstraints(SecurityContextConstraints securityContextConstraints) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected securityContextConstraints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecurityContextConstraints actualSecurityContextConstraints = actual.getSecurityContextConstraints();
    if (!Objects.areEqual(actualSecurityContextConstraints, securityContextConstraints)) {
      failWithMessage(assertjErrorMessage, actual, securityContextConstraints, actualSecurityContextConstraints);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's securityContextConstraintsList is equal to the given one.
   * @param securityContextConstraintsList the given securityContextConstraintsList to compare the actual KubeSchemaFluentImpl's securityContextConstraintsList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's securityContextConstraintsList is not equal to the given one.
   */
  public S hasSecurityContextConstraintsList(SecurityContextConstraintsList securityContextConstraintsList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected securityContextConstraintsList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecurityContextConstraintsList actualSecurityContextConstraintsList = actual.getSecurityContextConstraintsList();
    if (!Objects.areEqual(actualSecurityContextConstraintsList, securityContextConstraintsList)) {
      failWithMessage(assertjErrorMessage, actual, securityContextConstraintsList, actualSecurityContextConstraintsList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's serviceAccount is equal to the given one.
   * @param serviceAccount the given serviceAccount to compare the actual KubeSchemaFluentImpl's serviceAccount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's serviceAccount is not equal to the given one.
   */
  public S hasServiceAccount(ServiceAccount serviceAccount) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected serviceAccount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceAccount actualServiceAccount = actual.getServiceAccount();
    if (!Objects.areEqual(actualServiceAccount, serviceAccount)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccount, actualServiceAccount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's serviceAccountList is equal to the given one.
   * @param serviceAccountList the given serviceAccountList to compare the actual KubeSchemaFluentImpl's serviceAccountList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's serviceAccountList is not equal to the given one.
   */
  public S hasServiceAccountList(ServiceAccountList serviceAccountList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected serviceAccountList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceAccountList actualServiceAccountList = actual.getServiceAccountList();
    if (!Objects.areEqual(actualServiceAccountList, serviceAccountList)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccountList, actualServiceAccountList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's serviceList is equal to the given one.
   * @param serviceList the given serviceList to compare the actual KubeSchemaFluentImpl's serviceList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's serviceList is not equal to the given one.
   */
  public S hasServiceList(ServiceList serviceList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected serviceList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceList actualServiceList = actual.getServiceList();
    if (!Objects.areEqual(actualServiceList, serviceList)) {
      failWithMessage(assertjErrorMessage, actual, serviceList, actualServiceList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's status is equal to the given one.
   * @param status the given status to compare the actual KubeSchemaFluentImpl's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's status is not equal to the given one.
   */
  public S hasStatus(Status status) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Status actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's subjectAccessReview is equal to the given one.
   * @param subjectAccessReview the given subjectAccessReview to compare the actual KubeSchemaFluentImpl's subjectAccessReview to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's subjectAccessReview is not equal to the given one.
   */
  public S hasSubjectAccessReview(io.fabric8.openshift.api.model.SubjectAccessReview subjectAccessReview) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected subjectAccessReview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.SubjectAccessReview actualSubjectAccessReview = actual.getSubjectAccessReview();
    if (!Objects.areEqual(actualSubjectAccessReview, subjectAccessReview)) {
      failWithMessage(assertjErrorMessage, actual, subjectAccessReview, actualSubjectAccessReview);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's subjectAccessReviewResponse is equal to the given one.
   * @param subjectAccessReviewResponse the given subjectAccessReviewResponse to compare the actual KubeSchemaFluentImpl's subjectAccessReviewResponse to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's subjectAccessReviewResponse is not equal to the given one.
   */
  public S hasSubjectAccessReviewResponse(io.fabric8.openshift.api.model.SubjectAccessReviewResponse subjectAccessReviewResponse) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected subjectAccessReviewResponse of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.SubjectAccessReviewResponse actualSubjectAccessReviewResponse = actual.getSubjectAccessReviewResponse();
    if (!Objects.areEqual(actualSubjectAccessReviewResponse, subjectAccessReviewResponse)) {
      failWithMessage(assertjErrorMessage, actual, subjectAccessReviewResponse, actualSubjectAccessReviewResponse);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's tagEvent is equal to the given one.
   * @param tagEvent the given tagEvent to compare the actual KubeSchemaFluentImpl's tagEvent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's tagEvent is not equal to the given one.
   */
  public S hasTagEvent(io.fabric8.openshift.api.model.TagEvent tagEvent) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected tagEvent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.TagEvent actualTagEvent = actual.getTagEvent();
    if (!Objects.areEqual(actualTagEvent, tagEvent)) {
      failWithMessage(assertjErrorMessage, actual, tagEvent, actualTagEvent);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's template is equal to the given one.
   * @param template the given template to compare the actual KubeSchemaFluentImpl's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.openshift.api.model.Template template) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Template actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's templateList is equal to the given one.
   * @param templateList the given templateList to compare the actual KubeSchemaFluentImpl's templateList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's templateList is not equal to the given one.
   */
  public S hasTemplateList(io.fabric8.openshift.api.model.TemplateList templateList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected templateList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.TemplateList actualTemplateList = actual.getTemplateList();
    if (!Objects.areEqual(actualTemplateList, templateList)) {
      failWithMessage(assertjErrorMessage, actual, templateList, actualTemplateList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's user is equal to the given one.
   * @param user the given user to compare the actual KubeSchemaFluentImpl's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's user is not equal to the given one.
   */
  public S hasUser(io.fabric8.openshift.api.model.User user) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.User actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's userList is equal to the given one.
   * @param userList the given userList to compare the actual KubeSchemaFluentImpl's userList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's userList is not equal to the given one.
   */
  public S hasUserList(io.fabric8.openshift.api.model.UserList userList) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected userList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.UserList actualUserList = actual.getUserList();
    if (!Objects.areEqual(actualUserList, userList)) {
      failWithMessage(assertjErrorMessage, actual, userList, actualUserList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluentImpl's watchEvent is equal to the given one.
   * @param watchEvent the given watchEvent to compare the actual KubeSchemaFluentImpl's watchEvent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluentImpl's watchEvent is not equal to the given one.
   */
  public S hasWatchEvent(WatchEvent watchEvent) {
    // check that actual KubeSchemaFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected watchEvent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    WatchEvent actualWatchEvent = actual.getWatchEvent();
    if (!Objects.areEqual(actualWatchEvent, watchEvent)) {
      failWithMessage(assertjErrorMessage, actual, watchEvent, actualWatchEvent);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
