package io.fabric8.kubernetes.api.model;

import org.assertj.core.internal.Iterables;

/**
 * Abstract base class for {@link KubernetesList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesListAssert<S extends AbstractKubernetesListAssert<S, A>, A extends KubernetesList> extends AbstractBaseKubernetesListAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesListAssert}</code> to make assertions on actual KubernetesList.
   * @param actual the KubernetesList we want to make assertions on.
   */
  protected AbstractKubernetesListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubernetesList's items contains the given HasMetadata elements.
   * @param items the given elements that should be contained in actual KubernetesList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's items does not contain all given HasMetadata elements.
   */
  public S hasItems(HasMetadata... items) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given HasMetadata varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's items is not empty.
   */
  public S hasNoItems() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
