package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LoadBalancerIngressFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLoadBalancerIngressFluentImplAssert<S extends AbstractLoadBalancerIngressFluentImplAssert<S, A>, A extends LoadBalancerIngressFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLoadBalancerIngressFluentImplAssert}</code> to make assertions on actual LoadBalancerIngressFluentImpl.
   * @param actual the LoadBalancerIngressFluentImpl we want to make assertions on.
   */
  protected AbstractLoadBalancerIngressFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LoadBalancerIngressFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LoadBalancerIngressFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LoadBalancerIngressFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LoadBalancerIngressFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LoadBalancerIngressFluentImpl's hostname is equal to the given one.
   * @param hostname the given hostname to compare the actual LoadBalancerIngressFluentImpl's hostname to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LoadBalancerIngressFluentImpl's hostname is not equal to the given one.
   */
  public S hasHostname(String hostname) {
    // check that actual LoadBalancerIngressFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostname of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHostname = actual.getHostname();
    if (!Objects.areEqual(actualHostname, hostname)) {
      failWithMessage(assertjErrorMessage, actual, hostname, actualHostname);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LoadBalancerIngressFluentImpl's ip is equal to the given one.
   * @param ip the given ip to compare the actual LoadBalancerIngressFluentImpl's ip to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LoadBalancerIngressFluentImpl's ip is not equal to the given one.
   */
  public S hasIp(String ip) {
    // check that actual LoadBalancerIngressFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected ip of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualIp = actual.getIp();
    if (!Objects.areEqual(actualIp, ip)) {
      failWithMessage(assertjErrorMessage, actual, ip, actualIp);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
