package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedExtensionFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedExtensionFluentImplAssert<S extends AbstractNamedExtensionFluentImplAssert<S, A>, A extends NamedExtensionFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedExtensionFluentImplAssert}</code> to make assertions on actual NamedExtensionFluentImpl.
   * @param actual the NamedExtensionFluentImpl we want to make assertions on.
   */
  protected AbstractNamedExtensionFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedExtensionFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedExtensionFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedExtensionFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedExtensionFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedExtensionFluentImpl's extension is equal to the given one.
   * @param extension the given extension to compare the actual NamedExtensionFluentImpl's extension to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedExtensionFluentImpl's extension is not equal to the given one.
   */
  public S hasExtension(HasMetadata extension) {
    // check that actual NamedExtensionFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected extension of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HasMetadata actualExtension = actual.getExtension();
    if (!Objects.areEqual(actualExtension, extension)) {
      failWithMessage(assertjErrorMessage, actual, extension, actualExtension);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedExtensionFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual NamedExtensionFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedExtensionFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedExtensionFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
