package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeSpecFluentAssert<S extends AbstractNodeSpecFluentAssert<S, A>, A extends NodeSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeSpecFluentAssert}</code> to make assertions on actual NodeSpecFluent.
   * @param actual the NodeSpecFluent we want to make assertions on.
   */
  protected AbstractNodeSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSpecFluent's externalID is equal to the given one.
   * @param externalID the given externalID to compare the actual NodeSpecFluent's externalID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSpecFluent's externalID is not equal to the given one.
   */
  public S hasExternalID(String externalID) {
    // check that actual NodeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected externalID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualExternalID = actual.getExternalID();
    if (!Objects.areEqual(actualExternalID, externalID)) {
      failWithMessage(assertjErrorMessage, actual, externalID, actualExternalID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSpecFluent's podCIDR is equal to the given one.
   * @param podCIDR the given podCIDR to compare the actual NodeSpecFluent's podCIDR to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSpecFluent's podCIDR is not equal to the given one.
   */
  public S hasPodCIDR(String podCIDR) {
    // check that actual NodeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podCIDR of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPodCIDR = actual.getPodCIDR();
    if (!Objects.areEqual(actualPodCIDR, podCIDR)) {
      failWithMessage(assertjErrorMessage, actual, podCIDR, actualPodCIDR);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeSpecFluent's providerID is equal to the given one.
   * @param providerID the given providerID to compare the actual NodeSpecFluent's providerID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeSpecFluent's providerID is not equal to the given one.
   */
  public S hasProviderID(String providerID) {
    // check that actual NodeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected providerID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProviderID = actual.getProviderID();
    if (!Objects.areEqual(actualProviderID, providerID)) {
      failWithMessage(assertjErrorMessage, actual, providerID, actualProviderID);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
