package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ObjectFieldSelectorFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractObjectFieldSelectorFluentAssert<S extends AbstractObjectFieldSelectorFluentAssert<S, A>, A extends ObjectFieldSelectorFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractObjectFieldSelectorFluentAssert}</code> to make assertions on actual ObjectFieldSelectorFluent.
   * @param actual the ObjectFieldSelectorFluent we want to make assertions on.
   */
  protected AbstractObjectFieldSelectorFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ObjectFieldSelectorFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ObjectFieldSelectorFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectFieldSelectorFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ObjectFieldSelectorFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectFieldSelectorFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ObjectFieldSelectorFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectFieldSelectorFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ObjectFieldSelectorFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ObjectFieldSelectorFluent's fieldPath is equal to the given one.
   * @param fieldPath the given fieldPath to compare the actual ObjectFieldSelectorFluent's fieldPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectFieldSelectorFluent's fieldPath is not equal to the given one.
   */
  public S hasFieldPath(String fieldPath) {
    // check that actual ObjectFieldSelectorFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected fieldPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFieldPath = actual.getFieldPath();
    if (!Objects.areEqual(actualFieldPath, fieldPath)) {
      failWithMessage(assertjErrorMessage, actual, fieldPath, actualFieldPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
