package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSpecFluentAssert<S extends AbstractPodSpecFluentAssert<S, A>, A extends PodSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSpecFluentAssert}</code> to make assertions on actual PodSpecFluent.
   * @param actual the PodSpecFluent we want to make assertions on.
   */
  protected AbstractPodSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodSpecFluent's activeDeadlineSeconds is equal to the given one.
   * @param activeDeadlineSeconds the given activeDeadlineSeconds to compare the actual PodSpecFluent's activeDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's activeDeadlineSeconds is not equal to the given one.
   */
  public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualActiveDeadlineSeconds = actual.getActiveDeadlineSeconds();
    if (!Objects.areEqual(actualActiveDeadlineSeconds, activeDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, activeDeadlineSeconds, actualActiveDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's containers contains the given Container elements.
   * @param containers the given elements that should be contained in actual PodSpecFluent's containers.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpecFluent's containers does not contain all given Container elements.
   */
  public S hasContainers(Container... containers) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given Container varargs is not null.
    if (containers == null) throw new AssertionError("Expecting containers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getContainers(), containers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent has no containers.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpecFluent's containers is not empty.
   */
  public S hasNoContainers() {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have containers but had :\n  <%s>";
    
    // check
    if (actual.getContainers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getContainers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PodSpecFluent's dnsPolicy is equal to the given one.
   * @param dnsPolicy the given dnsPolicy to compare the actual PodSpecFluent's dnsPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's dnsPolicy is not equal to the given one.
   */
  public S hasDnsPolicy(String dnsPolicy) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected dnsPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDnsPolicy = actual.getDnsPolicy();
    if (!Objects.areEqual(actualDnsPolicy, dnsPolicy)) {
      failWithMessage(assertjErrorMessage, actual, dnsPolicy, actualDnsPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's host is equal to the given one.
   * @param host the given host to compare the actual PodSpecFluent's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's imagePullSecrets contains the given LocalObjectReference elements.
   * @param imagePullSecrets the given elements that should be contained in actual PodSpecFluent's imagePullSecrets.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpecFluent's imagePullSecrets does not contain all given LocalObjectReference elements.
   */
  public S hasImagePullSecrets(LocalObjectReference... imagePullSecrets) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given LocalObjectReference varargs is not null.
    if (imagePullSecrets == null) throw new AssertionError("Expecting imagePullSecrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getImagePullSecrets(), imagePullSecrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent has no imagePullSecrets.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpecFluent's imagePullSecrets is not empty.
   */
  public S hasNoImagePullSecrets() {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have imagePullSecrets but had :\n  <%s>";
    
    // check
    if (actual.getImagePullSecrets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getImagePullSecrets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PodSpecFluent's nodeName is equal to the given one.
   * @param nodeName the given nodeName to compare the actual PodSpecFluent's nodeName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's nodeName is not equal to the given one.
   */
  public S hasNodeName(String nodeName) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nodeName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNodeName = actual.getNodeName();
    if (!Objects.areEqual(actualNodeName, nodeName)) {
      failWithMessage(assertjErrorMessage, actual, nodeName, actualNodeName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's nodeSelector is equal to the given one.
   * @param nodeSelector the given nodeSelector to compare the actual PodSpecFluent's nodeSelector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's nodeSelector is not equal to the given one.
   */
  public S hasNodeSelector(java.util.Map nodeSelector) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nodeSelector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualNodeSelector = actual.getNodeSelector();
    if (!Objects.areEqual(actualNodeSelector, nodeSelector)) {
      failWithMessage(assertjErrorMessage, actual, nodeSelector, actualNodeSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's restartPolicy is equal to the given one.
   * @param restartPolicy the given restartPolicy to compare the actual PodSpecFluent's restartPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's restartPolicy is not equal to the given one.
   */
  public S hasRestartPolicy(String restartPolicy) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected restartPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRestartPolicy = actual.getRestartPolicy();
    if (!Objects.areEqual(actualRestartPolicy, restartPolicy)) {
      failWithMessage(assertjErrorMessage, actual, restartPolicy, actualRestartPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's serviceAccount is equal to the given one.
   * @param serviceAccount the given serviceAccount to compare the actual PodSpecFluent's serviceAccount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's serviceAccount is not equal to the given one.
   */
  public S hasServiceAccount(String serviceAccount) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected serviceAccount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServiceAccount = actual.getServiceAccount();
    if (!Objects.areEqual(actualServiceAccount, serviceAccount)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccount, actualServiceAccount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's serviceAccountName is equal to the given one.
   * @param serviceAccountName the given serviceAccountName to compare the actual PodSpecFluent's serviceAccountName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's serviceAccountName is not equal to the given one.
   */
  public S hasServiceAccountName(String serviceAccountName) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected serviceAccountName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServiceAccountName = actual.getServiceAccountName();
    if (!Objects.areEqual(actualServiceAccountName, serviceAccountName)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccountName, actualServiceAccountName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's terminationGracePeriodSeconds is equal to the given one.
   * @param terminationGracePeriodSeconds the given terminationGracePeriodSeconds to compare the actual PodSpecFluent's terminationGracePeriodSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpecFluent's terminationGracePeriodSeconds is not equal to the given one.
   */
  public S hasTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected terminationGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualTerminationGracePeriodSeconds = actual.getTerminationGracePeriodSeconds();
    if (!Objects.areEqual(actualTerminationGracePeriodSeconds, terminationGracePeriodSeconds)) {
      failWithMessage(assertjErrorMessage, actual, terminationGracePeriodSeconds, actualTerminationGracePeriodSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent's volumes contains the given Volume elements.
   * @param volumes the given elements that should be contained in actual PodSpecFluent's volumes.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpecFluent's volumes does not contain all given Volume elements.
   */
  public S hasVolumes(Volume... volumes) {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given Volume varargs is not null.
    if (volumes == null) throw new AssertionError("Expecting volumes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVolumes(), volumes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpecFluent has no volumes.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpecFluent's volumes is not empty.
   */
  public S hasNoVolumes() {
    // check that actual PodSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumes but had :\n  <%s>";
    
    // check
    if (actual.getVolumes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVolumes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
