package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodTemplateSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateSpecFluentImplAssert<S extends AbstractPodTemplateSpecFluentImplAssert<S, A>, A extends PodTemplateSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateSpecFluentImplAssert}</code> to make assertions on actual PodTemplateSpecFluentImpl.
   * @param actual the PodTemplateSpecFluentImpl we want to make assertions on.
   */
  protected AbstractPodTemplateSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodTemplateSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodTemplateSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodTemplateSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpecFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual PodTemplateSpecFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpecFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual PodTemplateSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateSpecFluentImpl's spec is equal to the given one.
   * @param spec the given spec to compare the actual PodTemplateSpecFluentImpl's spec to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateSpecFluentImpl's spec is not equal to the given one.
   */
  public S hasSpec(PodSpec spec) {
    // check that actual PodTemplateSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected spec of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodSpec actualSpec = actual.getSpec();
    if (!Objects.areEqual(actualSpec, spec)) {
      failWithMessage(assertjErrorMessage, actual, spec, actualSpec);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
