package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Quantity} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractQuantityAssert<S extends AbstractQuantityAssert<S, A>, A extends Quantity> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractQuantityAssert}</code> to make assertions on actual Quantity.
   * @param actual the Quantity we want to make assertions on.
   */
  protected AbstractQuantityAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Quantity's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Quantity's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Quantity's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Quantity we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Quantity's amount is equal to the given one.
   * @param amount the given amount to compare the actual Quantity's amount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Quantity's amount is not equal to the given one.
   */
  public S hasAmount(String amount) {
    // check that actual Quantity we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected amount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualAmount = actual.getAmount();
    if (!Objects.areEqual(actualAmount, amount)) {
      failWithMessage(assertjErrorMessage, actual, amount, actualAmount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Quantity's format is equal to the given one.
   * @param format the given format to compare the actual Quantity's format to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Quantity's format is not equal to the given one.
   */
  public S hasFormat(String format) {
    // check that actual Quantity we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected format of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFormat = actual.getFormat();
    if (!Objects.areEqual(actualFormat, format)) {
      failWithMessage(assertjErrorMessage, actual, format, actualFormat);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
