package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RBDVolumeSourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRBDVolumeSourceFluentImplAssert<S extends AbstractRBDVolumeSourceFluentImplAssert<S, A>, A extends RBDVolumeSourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRBDVolumeSourceFluentImplAssert}</code> to make assertions on actual RBDVolumeSourceFluentImpl.
   * @param actual the RBDVolumeSourceFluentImpl we want to make assertions on.
   */
  protected AbstractRBDVolumeSourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RBDVolumeSourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RBDVolumeSourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl's fsType is equal to the given one.
   * @param fsType the given fsType to compare the actual RBDVolumeSourceFluentImpl's fsType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RBDVolumeSourceFluentImpl's fsType is not equal to the given one.
   */
  public S hasFsType(String fsType) {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected fsType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFsType = actual.getFsType();
    if (!Objects.areEqual(actualFsType, fsType)) {
      failWithMessage(assertjErrorMessage, actual, fsType, actualFsType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl's image is equal to the given one.
   * @param image the given image to compare the actual RBDVolumeSourceFluentImpl's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RBDVolumeSourceFluentImpl's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl's keyring is equal to the given one.
   * @param keyring the given keyring to compare the actual RBDVolumeSourceFluentImpl's keyring to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RBDVolumeSourceFluentImpl's keyring is not equal to the given one.
   */
  public S hasKeyring(String keyring) {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected keyring of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKeyring = actual.getKeyring();
    if (!Objects.areEqual(actualKeyring, keyring)) {
      failWithMessage(assertjErrorMessage, actual, keyring, actualKeyring);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl's monitors contains the given String elements.
   * @param monitors the given elements that should be contained in actual RBDVolumeSourceFluentImpl's monitors.
   * @return this assertion object.
   * @throws AssertionError if the actual RBDVolumeSourceFluentImpl's monitors does not contain all given String elements.
   */
  public S hasMonitors(String... monitors) {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (monitors == null) throw new AssertionError("Expecting monitors parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getMonitors(), monitors);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl has no monitors.
   * @return this assertion object.
   * @throws AssertionError if the actual RBDVolumeSourceFluentImpl's monitors is not empty.
   */
  public S hasNoMonitors() {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have monitors but had :\n  <%s>";
    
    // check
    if (actual.getMonitors().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getMonitors());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl's pool is equal to the given one.
   * @param pool the given pool to compare the actual RBDVolumeSourceFluentImpl's pool to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RBDVolumeSourceFluentImpl's pool is not equal to the given one.
   */
  public S hasPool(String pool) {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected pool of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPool = actual.getPool();
    if (!Objects.areEqual(actualPool, pool)) {
      failWithMessage(assertjErrorMessage, actual, pool, actualPool);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl's secretRef is equal to the given one.
   * @param secretRef the given secretRef to compare the actual RBDVolumeSourceFluentImpl's secretRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RBDVolumeSourceFluentImpl's secretRef is not equal to the given one.
   */
  public S hasSecretRef(LocalObjectReference secretRef) {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secretRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LocalObjectReference actualSecretRef = actual.getSecretRef();
    if (!Objects.areEqual(actualSecretRef, secretRef)) {
      failWithMessage(assertjErrorMessage, actual, secretRef, actualSecretRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RBDVolumeSourceFluentImpl's user is equal to the given one.
   * @param user the given user to compare the actual RBDVolumeSourceFluentImpl's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RBDVolumeSourceFluentImpl's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual RBDVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
