package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SELinuxOptionsFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSELinuxOptionsFluentAssert<S extends AbstractSELinuxOptionsFluentAssert<S, A>, A extends SELinuxOptionsFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSELinuxOptionsFluentAssert}</code> to make assertions on actual SELinuxOptionsFluent.
   * @param actual the SELinuxOptionsFluent we want to make assertions on.
   */
  protected AbstractSELinuxOptionsFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SELinuxOptionsFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SELinuxOptionsFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptionsFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SELinuxOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxOptionsFluent's level is equal to the given one.
   * @param level the given level to compare the actual SELinuxOptionsFluent's level to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptionsFluent's level is not equal to the given one.
   */
  public S hasLevel(String level) {
    // check that actual SELinuxOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected level of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLevel = actual.getLevel();
    if (!Objects.areEqual(actualLevel, level)) {
      failWithMessage(assertjErrorMessage, actual, level, actualLevel);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxOptionsFluent's role is equal to the given one.
   * @param role the given role to compare the actual SELinuxOptionsFluent's role to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptionsFluent's role is not equal to the given one.
   */
  public S hasRole(String role) {
    // check that actual SELinuxOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected role of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRole = actual.getRole();
    if (!Objects.areEqual(actualRole, role)) {
      failWithMessage(assertjErrorMessage, actual, role, actualRole);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxOptionsFluent's type is equal to the given one.
   * @param type the given type to compare the actual SELinuxOptionsFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptionsFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual SELinuxOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SELinuxOptionsFluent's user is equal to the given one.
   * @param user the given user to compare the actual SELinuxOptionsFluent's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SELinuxOptionsFluent's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual SELinuxOptionsFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
