package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SecurityContextFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecurityContextFluentAssert<S extends AbstractSecurityContextFluentAssert<S, A>, A extends SecurityContextFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecurityContextFluentAssert}</code> to make assertions on actual SecurityContextFluent.
   * @param actual the SecurityContextFluent we want to make assertions on.
   */
  protected AbstractSecurityContextFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SecurityContextFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SecurityContextFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextFluent's capabilities is equal to the given one.
   * @param capabilities the given capabilities to compare the actual SecurityContextFluent's capabilities to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextFluent's capabilities is not equal to the given one.
   */
  public S hasCapabilities(Capabilities capabilities) {
    // check that actual SecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected capabilities of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Capabilities actualCapabilities = actual.getCapabilities();
    if (!Objects.areEqual(actualCapabilities, capabilities)) {
      failWithMessage(assertjErrorMessage, actual, capabilities, actualCapabilities);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextFluent's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual SecurityContextFluent's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextFluent's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(Long runAsUser) {
    // check that actual SecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SecurityContextFluent's seLinuxOptions is equal to the given one.
   * @param seLinuxOptions the given seLinuxOptions to compare the actual SecurityContextFluent's seLinuxOptions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContextFluent's seLinuxOptions is not equal to the given one.
   */
  public S hasSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    // check that actual SecurityContextFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected seLinuxOptions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SELinuxOptions actualSeLinuxOptions = actual.getSeLinuxOptions();
    if (!Objects.areEqual(actualSeLinuxOptions, seLinuxOptions)) {
      failWithMessage(assertjErrorMessage, actual, seLinuxOptions, actualSeLinuxOptions);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
