package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ServiceStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceStatusAssert<S extends AbstractServiceStatusAssert<S, A>, A extends ServiceStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceStatusAssert}</code> to make assertions on actual ServiceStatus.
   * @param actual the ServiceStatus we want to make assertions on.
   */
  protected AbstractServiceStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ServiceStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ServiceStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ServiceStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceStatus's loadBalancer is equal to the given one.
   * @param loadBalancer the given loadBalancer to compare the actual ServiceStatus's loadBalancer to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceStatus's loadBalancer is not equal to the given one.
   */
  public S hasLoadBalancer(LoadBalancerStatus loadBalancer) {
    // check that actual ServiceStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected loadBalancer of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LoadBalancerStatus actualLoadBalancer = actual.getLoadBalancer();
    if (!Objects.areEqual(actualLoadBalancer, loadBalancer)) {
      failWithMessage(assertjErrorMessage, actual, loadBalancer, actualLoadBalancer);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
