package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link StatusDetails} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatusDetailsAssert<S extends AbstractStatusDetailsAssert<S, A>, A extends StatusDetails> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatusDetailsAssert}</code> to make assertions on actual StatusDetails.
   * @param actual the StatusDetails we want to make assertions on.
   */
  protected AbstractStatusDetailsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual StatusDetails's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual StatusDetails's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusDetails's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusDetails's causes contains the given StatusCause elements.
   * @param causes the given elements that should be contained in actual StatusDetails's causes.
   * @return this assertion object.
   * @throws AssertionError if the actual StatusDetails's causes does not contain all given StatusCause elements.
   */
  public S hasCauses(StatusCause... causes) {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // check that given StatusCause varargs is not null.
    if (causes == null) throw new AssertionError("Expecting causes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCauses(), causes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusDetails has no causes.
   * @return this assertion object.
   * @throws AssertionError if the actual StatusDetails's causes is not empty.
   */
  public S hasNoCauses() {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have causes but had :\n  <%s>";
    
    // check
    if (actual.getCauses().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCauses());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual StatusDetails's kind is equal to the given one.
   * @param kind the given kind to compare the actual StatusDetails's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusDetails's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusDetails's name is equal to the given one.
   * @param name the given name to compare the actual StatusDetails's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusDetails's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatusDetails's retryAfterSeconds is equal to the given one.
   * @param retryAfterSeconds the given retryAfterSeconds to compare the actual StatusDetails's retryAfterSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatusDetails's retryAfterSeconds is not equal to the given one.
   */
  public S hasRetryAfterSeconds(Integer retryAfterSeconds) {
    // check that actual StatusDetails we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected retryAfterSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRetryAfterSeconds = actual.getRetryAfterSeconds();
    if (!Objects.areEqual(actualRetryAfterSeconds, retryAfterSeconds)) {
      failWithMessage(assertjErrorMessage, actual, retryAfterSeconds, actualRetryAfterSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
