package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildRequest} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildRequestAssert<S extends AbstractBuildRequestAssert<S, A>, A extends BuildRequest> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildRequestAssert}</code> to make assertions on actual BuildRequest.
   * @param actual the BuildRequest we want to make assertions on.
   */
  protected AbstractBuildRequestAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildRequest's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildRequest's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildRequest's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual BuildRequest's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(BuildRequest.ApiVersion apiVersion) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BuildRequest.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildRequest's from is equal to the given one.
   * @param from the given from to compare the actual BuildRequest's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildRequest's kind is equal to the given one.
   * @param kind the given kind to compare the actual BuildRequest's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildRequest's lastVersion is equal to the given one.
   * @param lastVersion the given lastVersion to compare the actual BuildRequest's lastVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's lastVersion is not equal to the given one.
   */
  public S hasLastVersion(Integer lastVersion) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected lastVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLastVersion = actual.getLastVersion();
    if (!Objects.areEqual(actualLastVersion, lastVersion)) {
      failWithMessage(assertjErrorMessage, actual, lastVersion, actualLastVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildRequest's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual BuildRequest's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildRequest's revision is equal to the given one.
   * @param revision the given revision to compare the actual BuildRequest's revision to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's revision is not equal to the given one.
   */
  public S hasRevision(SourceRevision revision) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected revision of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SourceRevision actualRevision = actual.getRevision();
    if (!Objects.areEqual(actualRevision, revision)) {
      failWithMessage(assertjErrorMessage, actual, revision, actualRevision);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildRequest's triggeredByImage is equal to the given one.
   * @param triggeredByImage the given triggeredByImage to compare the actual BuildRequest's triggeredByImage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildRequest's triggeredByImage is not equal to the given one.
   */
  public S hasTriggeredByImage(io.fabric8.kubernetes.api.model.ObjectReference triggeredByImage) {
    // check that actual BuildRequest we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected triggeredByImage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualTriggeredByImage = actual.getTriggeredByImage();
    if (!Objects.areEqual(actualTriggeredByImage, triggeredByImage)) {
      failWithMessage(assertjErrorMessage, actual, triggeredByImage, actualTriggeredByImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
