package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildStatusFluentImplAssert<S extends AbstractBuildStatusFluentImplAssert<S, A>, A extends BuildStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildStatusFluentImplAssert}</code> to make assertions on actual BuildStatusFluentImpl.
   * @param actual the BuildStatusFluentImpl we want to make assertions on.
   */
  protected AbstractBuildStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStatusFluentImpl's completionTimestamp is equal to the given one.
   * @param completionTimestamp the given completionTimestamp to compare the actual BuildStatusFluentImpl's completionTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStatusFluentImpl's completionTimestamp is not equal to the given one.
   */
  public S hasCompletionTimestamp(String completionTimestamp) {
    // check that actual BuildStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected completionTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCompletionTimestamp = actual.getCompletionTimestamp();
    if (!Objects.areEqual(actualCompletionTimestamp, completionTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, completionTimestamp, actualCompletionTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStatusFluentImpl's config is equal to the given one.
   * @param config the given config to compare the actual BuildStatusFluentImpl's config to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStatusFluentImpl's config is not equal to the given one.
   */
  public S hasConfig(io.fabric8.kubernetes.api.model.ObjectReference config) {
    // check that actual BuildStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected config of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualConfig = actual.getConfig();
    if (!Objects.areEqual(actualConfig, config)) {
      failWithMessage(assertjErrorMessage, actual, config, actualConfig);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStatusFluentImpl's duration is equal to the given one.
   * @param duration the given duration to compare the actual BuildStatusFluentImpl's duration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStatusFluentImpl's duration is not equal to the given one.
   */
  public S hasDuration(Long duration) {
    // check that actual BuildStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected duration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualDuration = actual.getDuration();
    if (!Objects.areEqual(actualDuration, duration)) {
      failWithMessage(assertjErrorMessage, actual, duration, actualDuration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStatusFluentImpl's message is equal to the given one.
   * @param message the given message to compare the actual BuildStatusFluentImpl's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStatusFluentImpl's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual BuildStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStatusFluentImpl's phase is equal to the given one.
   * @param phase the given phase to compare the actual BuildStatusFluentImpl's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStatusFluentImpl's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual BuildStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStatusFluentImpl's startTimestamp is equal to the given one.
   * @param startTimestamp the given startTimestamp to compare the actual BuildStatusFluentImpl's startTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStatusFluentImpl's startTimestamp is not equal to the given one.
   */
  public S hasStartTimestamp(String startTimestamp) {
    // check that actual BuildStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected startTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStartTimestamp = actual.getStartTimestamp();
    if (!Objects.areEqual(actualStartTimestamp, startTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, startTimestamp, actualStartTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
