package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildStrategyFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildStrategyFluentImplAssert<S extends AbstractBuildStrategyFluentImplAssert<S, A>, A extends BuildStrategyFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildStrategyFluentImplAssert}</code> to make assertions on actual BuildStrategyFluentImpl.
   * @param actual the BuildStrategyFluentImpl we want to make assertions on.
   */
  protected AbstractBuildStrategyFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildStrategyFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildStrategyFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategyFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStrategyFluentImpl's customStrategy is equal to the given one.
   * @param customStrategy the given customStrategy to compare the actual BuildStrategyFluentImpl's customStrategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategyFluentImpl's customStrategy is not equal to the given one.
   */
  public S hasCustomStrategy(CustomBuildStrategy customStrategy) {
    // check that actual BuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected customStrategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CustomBuildStrategy actualCustomStrategy = actual.getCustomStrategy();
    if (!Objects.areEqual(actualCustomStrategy, customStrategy)) {
      failWithMessage(assertjErrorMessage, actual, customStrategy, actualCustomStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStrategyFluentImpl's dockerStrategy is equal to the given one.
   * @param dockerStrategy the given dockerStrategy to compare the actual BuildStrategyFluentImpl's dockerStrategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategyFluentImpl's dockerStrategy is not equal to the given one.
   */
  public S hasDockerStrategy(DockerBuildStrategy dockerStrategy) {
    // check that actual BuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected dockerStrategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DockerBuildStrategy actualDockerStrategy = actual.getDockerStrategy();
    if (!Objects.areEqual(actualDockerStrategy, dockerStrategy)) {
      failWithMessage(assertjErrorMessage, actual, dockerStrategy, actualDockerStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStrategyFluentImpl's sourceStrategy is equal to the given one.
   * @param sourceStrategy the given sourceStrategy to compare the actual BuildStrategyFluentImpl's sourceStrategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategyFluentImpl's sourceStrategy is not equal to the given one.
   */
  public S hasSourceStrategy(SourceBuildStrategy sourceStrategy) {
    // check that actual BuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected sourceStrategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SourceBuildStrategy actualSourceStrategy = actual.getSourceStrategy();
    if (!Objects.areEqual(actualSourceStrategy, sourceStrategy)) {
      failWithMessage(assertjErrorMessage, actual, sourceStrategy, actualSourceStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildStrategyFluentImpl's type is equal to the given one.
   * @param type the given type to compare the actual BuildStrategyFluentImpl's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildStrategyFluentImpl's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual BuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
