package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentCauseFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentCauseFluentImplAssert<S extends AbstractDeploymentCauseFluentImplAssert<S, A>, A extends DeploymentCauseFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentCauseFluentImplAssert}</code> to make assertions on actual DeploymentCauseFluentImpl.
   * @param actual the DeploymentCauseFluentImpl we want to make assertions on.
   */
  protected AbstractDeploymentCauseFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentCauseFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentCauseFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentCauseFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentCauseFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentCauseFluentImpl's imageTrigger is equal to the given one.
   * @param imageTrigger the given imageTrigger to compare the actual DeploymentCauseFluentImpl's imageTrigger to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentCauseFluentImpl's imageTrigger is not equal to the given one.
   */
  public S hasImageTrigger(DeploymentCauseImageTrigger imageTrigger) {
    // check that actual DeploymentCauseFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageTrigger of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeploymentCauseImageTrigger actualImageTrigger = actual.getImageTrigger();
    if (!Objects.areEqual(actualImageTrigger, imageTrigger)) {
      failWithMessage(assertjErrorMessage, actual, imageTrigger, actualImageTrigger);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentCauseFluentImpl's type is equal to the given one.
   * @param type the given type to compare the actual DeploymentCauseFluentImpl's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentCauseFluentImpl's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual DeploymentCauseFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
