package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ExecNewPodHookFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractExecNewPodHookFluentAssert<S extends AbstractExecNewPodHookFluentAssert<S, A>, A extends ExecNewPodHookFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractExecNewPodHookFluentAssert}</code> to make assertions on actual ExecNewPodHookFluent.
   * @param actual the ExecNewPodHookFluent we want to make assertions on.
   */
  protected AbstractExecNewPodHookFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ExecNewPodHookFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ExecNewPodHookFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ExecNewPodHookFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ExecNewPodHookFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecNewPodHookFluent's command contains the given String elements.
   * @param command the given elements that should be contained in actual ExecNewPodHookFluent's command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecNewPodHookFluent's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual ExecNewPodHookFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) throw new AssertionError("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecNewPodHookFluent has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecNewPodHookFluent's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual ExecNewPodHookFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ExecNewPodHookFluent's containerName is equal to the given one.
   * @param containerName the given containerName to compare the actual ExecNewPodHookFluent's containerName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ExecNewPodHookFluent's containerName is not equal to the given one.
   */
  public S hasContainerName(String containerName) {
    // check that actual ExecNewPodHookFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContainerName = actual.getContainerName();
    if (!Objects.areEqual(actualContainerName, containerName)) {
      failWithMessage(assertjErrorMessage, actual, containerName, actualContainerName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecNewPodHookFluent's env contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param env the given elements that should be contained in actual ExecNewPodHookFluent's env.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecNewPodHookFluent's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual ExecNewPodHookFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) throw new AssertionError("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ExecNewPodHookFluent has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual ExecNewPodHookFluent's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual ExecNewPodHookFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
