package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ImageStreamSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageStreamSpecFluentImplAssert<S extends AbstractImageStreamSpecFluentImplAssert<S, A>, A extends ImageStreamSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageStreamSpecFluentImplAssert}</code> to make assertions on actual ImageStreamSpecFluentImpl.
   * @param actual the ImageStreamSpecFluentImpl we want to make assertions on.
   */
  protected AbstractImageStreamSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ImageStreamSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ImageStreamSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageStreamSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ImageStreamSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageStreamSpecFluentImpl's dockerImageRepository is equal to the given one.
   * @param dockerImageRepository the given dockerImageRepository to compare the actual ImageStreamSpecFluentImpl's dockerImageRepository to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageStreamSpecFluentImpl's dockerImageRepository is not equal to the given one.
   */
  public S hasDockerImageRepository(String dockerImageRepository) {
    // check that actual ImageStreamSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected dockerImageRepository of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageRepository = actual.getDockerImageRepository();
    if (!Objects.areEqual(actualDockerImageRepository, dockerImageRepository)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageRepository, actualDockerImageRepository);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageStreamSpecFluentImpl's tags contains the given NamedTagReference elements.
   * @param tags the given elements that should be contained in actual ImageStreamSpecFluentImpl's tags.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageStreamSpecFluentImpl's tags does not contain all given NamedTagReference elements.
   */
  public S hasTags(NamedTagReference... tags) {
    // check that actual ImageStreamSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NamedTagReference varargs is not null.
    if (tags == null) throw new AssertionError("Expecting tags parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTags(), tags);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageStreamSpecFluentImpl has no tags.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageStreamSpecFluentImpl's tags is not empty.
   */
  public S hasNoTags() {
    // check that actual ImageStreamSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have tags but had :\n  <%s>";
    
    // check
    if (actual.getTags().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTags());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
